/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.AbstractColumnComparisonCondition;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.AbstractNoValueCondition;
import org.mybatis.dynamic.sql.AbstractSingleValueCondition;
import org.mybatis.dynamic.sql.AbstractSubselectCondition;
import org.mybatis.dynamic.sql.AbstractTwoValueCondition;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ConditionVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.render.SelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;

public class WhereConditionVisitor<T>
implements ConditionVisitor<T, FragmentAndParameters> {
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence;
    private final BindableColumn<T> column;
    private final TableAliasCalculator tableAliasCalculator;
    private final String parameterPrefix;

    private WhereConditionVisitor(Builder<T> builder) {
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
        this.sequence = Objects.requireNonNull(((Builder)builder).sequence);
        this.column = Objects.requireNonNull(((Builder)builder).column);
        this.tableAliasCalculator = Objects.requireNonNull(((Builder)builder).tableAliasCalculator);
        this.parameterPrefix = Objects.requireNonNull(((Builder)builder).parameterPrefix);
    }

    @Override
    public FragmentAndParameters visit(AbstractListValueCondition<T> condition) {
        FragmentCollector fc = condition.mapValues(this::toFragmentAndParameters).collect(FragmentCollector.collect());
        return FragmentAndParameters.withFragment(condition.renderCondition(this.columnName(), fc.fragments())).withParameters(fc.parameters()).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractNoValueCondition<T> condition) {
        return FragmentAndParameters.withFragment(condition.renderCondition(this.columnName())).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractSingleValueCondition<T> condition) {
        String mapKey = RenderingStrategy.formatParameterMapKey(this.sequence);
        String fragment = condition.renderCondition(this.columnName(), this.getFormattedJdbcPlaceholder(mapKey));
        return FragmentAndParameters.withFragment(fragment).withParameter(mapKey, this.convertValue(condition.value())).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractTwoValueCondition<T> condition) {
        String mapKey1 = RenderingStrategy.formatParameterMapKey(this.sequence);
        String mapKey2 = RenderingStrategy.formatParameterMapKey(this.sequence);
        String fragment = condition.renderCondition(this.columnName(), this.getFormattedJdbcPlaceholder(mapKey1), this.getFormattedJdbcPlaceholder(mapKey2));
        return FragmentAndParameters.withFragment(fragment).withParameter(mapKey1, this.convertValue(condition.value1())).withParameter(mapKey2, this.convertValue(condition.value2())).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractSubselectCondition<T> condition) {
        SelectStatementProvider selectStatement = ((SelectRenderer.Builder)((SelectRenderer.Builder)((SelectRenderer.Builder)SelectRenderer.withSelectModel(condition.selectModel()).withRenderingStrategy(this.renderingStrategy)).withSequence(this.sequence)).withParentTableAliasCalculator(this.tableAliasCalculator)).build().render();
        String fragment = condition.renderCondition(this.columnName(), selectStatement.getSelectStatement());
        return FragmentAndParameters.withFragment(fragment).withParameters(selectStatement.getParameters()).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractColumnComparisonCondition<T> condition) {
        String fragment = condition.renderCondition(this.columnName(), this.tableAliasCalculator);
        return FragmentAndParameters.withFragment(fragment).build();
    }

    private Object convertValue(T value) {
        return this.column.convertParameterType(value);
    }

    private FragmentAndParameters toFragmentAndParameters(T value) {
        String mapKey = RenderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment(this.getFormattedJdbcPlaceholder(mapKey)).withParameter(mapKey, this.convertValue(value)).build();
    }

    private String getFormattedJdbcPlaceholder(String mapKey) {
        return this.column.renderingStrategy().orElse(this.renderingStrategy).getFormattedJdbcPlaceholder(this.column, this.parameterPrefix, mapKey);
    }

    private String columnName() {
        return this.column.renderWithTableAlias(this.tableAliasCalculator);
    }

    public static <T> Builder<T> withColumn(BindableColumn<T> column) {
        return new Builder<T>().withColumn(column);
    }

    public static class Builder<T> {
        private RenderingStrategy renderingStrategy;
        private AtomicInteger sequence;
        private BindableColumn<T> column;
        private TableAliasCalculator tableAliasCalculator;
        private String parameterPrefix = "parameters";

        public Builder<T> withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder<T> withColumn(BindableColumn<T> column) {
            this.column = column;
            return this;
        }

        public Builder<T> withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this;
        }

        public Builder<T> withParameterName(String parameterName) {
            if (parameterName != null) {
                this.parameterPrefix = parameterName + "." + "parameters";
            }
            return this;
        }

        public WhereConditionVisitor<T> build() {
            return new WhereConditionVisitor(this);
        }
    }
}

