/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.CriterionRenderer;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;

public class WhereRenderer {
    private final WhereModel whereModel;
    private final CriterionRenderer criterionRenderer;

    private WhereRenderer(Builder builder) {
        this.whereModel = Objects.requireNonNull(builder.whereModel);
        this.criterionRenderer = new CriterionRenderer.Builder().withSequence(builder.sequence).withRenderingStrategy(builder.renderingStrategy).withTableAliasCalculator(builder.tableAliasCalculator).withParameterName(builder.parameterName).build();
    }

    public Optional<WhereClauseProvider> render() {
        return this.whereModel.initialCriterion().map(ic -> this.criterionRenderer.render((SqlCriterion)ic, this.whereModel.subCriteria(), this::calculateWhereClause)).orElseGet(() -> this.criterionRenderer.render(this.whereModel.subCriteria(), this::calculateWhereClause)).map(rc -> WhereClauseProvider.withWhereClause(rc.fragmentAndParameters().fragment()).withParameters(rc.fragmentAndParameters().parameters()).build());
    }

    private String calculateWhereClause(FragmentCollector collector) {
        return collector.fragments().collect(Collectors.joining(" ", "where ", ""));
    }

    public static Builder withWhereModel(WhereModel whereModel) {
        return new Builder().withWhereModel(whereModel);
    }

    public static class Builder {
        private WhereModel whereModel;
        private RenderingStrategy renderingStrategy;
        private TableAliasCalculator tableAliasCalculator;
        private AtomicInteger sequence;
        private String parameterName;

        public Builder withWhereModel(WhereModel whereModel) {
            this.whereModel = whereModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this;
        }

        public Builder withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder withParameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public WhereRenderer build() {
            return new WhereRenderer(this);
        }
    }
}

