/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.messages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.agrona.concurrent.UnsafeBuffer;
import org.nd4j.linalg.util.SerializationUtils;
import org.nd4j.parameterserver.distributed.conf.VoidConfiguration;
import org.nd4j.parameterserver.distributed.enums.NodeRole;
import org.nd4j.parameterserver.distributed.logic.Storage;
import org.nd4j.parameterserver.distributed.logic.completion.Clipboard;
import org.nd4j.parameterserver.distributed.messages.BaseVoidMessage;
import org.nd4j.parameterserver.distributed.messages.TrainingMessage;
import org.nd4j.parameterserver.distributed.messages.VoidMessage;
import org.nd4j.parameterserver.distributed.training.TrainingDriver;
import org.nd4j.parameterserver.distributed.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Frame<T extends TrainingMessage>
implements Serializable,
Iterable<T>,
VoidMessage {
    private static final Logger log = LoggerFactory.getLogger(Frame.class);
    protected List<T> list = new ArrayList<T>();
    protected long originatorId;
    protected short targetId;
    protected long taskId;
    protected transient VoidConfiguration voidConfiguration;
    protected transient Clipboard clipboard;
    protected transient Transport transport;
    protected transient Storage storage;
    protected transient NodeRole role;
    protected transient short shardIndex;
    protected transient TrainingDriver<? extends TrainingMessage> trainer;
    protected transient int retransmitCount = 0;

    protected Frame() {
    }

    public Frame(long taskId) {
        this.taskId = taskId;
    }

    public Frame(@NonNull T message) {
        this();
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        this.list.add(message);
    }

    @Override
    public void setOriginatorId(long id) {
        this.originatorId = id;
        if (this.list != null) {
            this.list.forEach(msg -> msg.setOriginatorId(this.getOriginatorId()));
        }
    }

    public synchronized void stackMessage(@NonNull T message) {
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        this.stackMessageUnlocked(message);
    }

    private void stackMessageUnlocked(@NonNull T message) {
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        if (message.isJoinSupported()) {
            int index = this.list.indexOf(message);
            if (index >= 0) {
                ((TrainingMessage)this.list.get(index)).joinMessage((VoidMessage)message);
            } else {
                message.setFrameId(this.getTaskId());
                this.list.add(message);
            }
        } else {
            message.setFrameId(this.getTaskId());
            this.list.add(message);
        }
    }

    public synchronized void stackMessages(@NonNull Collection<T> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked @NonNull but is null");
        }
        for (TrainingMessage message : messages) {
            this.stackMessageUnlocked(message);
        }
    }

    public synchronized void stackMessages(T ... messages) {
        for (T message : messages) {
            if (message == null) continue;
            this.stackMessageUnlocked(message);
        }
    }

    public Collection<T> getMessages() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int getMessageType() {
        return 3;
    }

    @Override
    public byte[] asBytes() {
        return SerializationUtils.toByteArray((Serializable)this);
    }

    @Override
    public UnsafeBuffer asUnsafeBuffer() {
        return new UnsafeBuffer(this.asBytes());
    }

    @Override
    public void attachContext(@NonNull VoidConfiguration voidConfiguration, @NonNull TrainingDriver<? extends TrainingMessage> trainer, @NonNull Clipboard clipboard, @NonNull Transport transport, @NonNull Storage storage, @NonNull NodeRole role, short shardIndex) {
        if (voidConfiguration == null) {
            throw new NullPointerException("voidConfiguration is marked @NonNull but is null");
        }
        if (trainer == null) {
            throw new NullPointerException("trainer is marked @NonNull but is null");
        }
        if (clipboard == null) {
            throw new NullPointerException("clipboard is marked @NonNull but is null");
        }
        if (transport == null) {
            throw new NullPointerException("transport is marked @NonNull but is null");
        }
        if (storage == null) {
            throw new NullPointerException("storage is marked @NonNull but is null");
        }
        if (role == null) {
            throw new NullPointerException("role is marked @NonNull but is null");
        }
        this.voidConfiguration = voidConfiguration;
        this.clipboard = clipboard;
        this.transport = transport;
        this.storage = storage;
        this.role = role;
        this.shardIndex = shardIndex;
        this.trainer = trainer;
    }

    @Override
    public void extractContext(@NonNull BaseVoidMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        this.voidConfiguration = message.voidConfiguration;
        this.clipboard = message.clipboard;
        this.transport = message.transport;
        this.storage = message.storage;
        this.role = message.role;
        this.shardIndex = message.shardIndex;
        this.trainer = message.trainer;
        this.originatorId = message.originatorId;
    }

    @Override
    public void processMessage() {
        if (this.trainer != null && this.transport != null) {
            this.list.forEach(message -> this.trainer.addCompletionHook(this.getOriginatorId(), this.getTaskId(), message.getTaskId()));
        }
        for (TrainingMessage message2 : this.list) {
            if (this.trainer != null && this.transport != null) {
                message2.attachContext(this.voidConfiguration, this.trainer, this.clipboard, this.transport, this.storage, this.role, this.shardIndex);
            }
            for (int i = 0; i < message2.getCounter(); ++i) {
                message2.processMessage();
            }
        }
    }

    @Override
    public boolean isJoinSupported() {
        return false;
    }

    @Override
    public void joinMessage(VoidMessage message) {
    }

    @Override
    public boolean isBlockingMessage() {
        return true;
    }

    @Override
    public void incrementRetransmitCount() {
        ++this.retransmitCount;
    }

    protected List<T> getList() {
        return this.list;
    }

    protected void setList(List<T> list) {
        this.list = list;
    }

    @Override
    public long getOriginatorId() {
        return this.originatorId;
    }

    @Override
    public short getTargetId() {
        return this.targetId;
    }

    @Override
    public void setTargetId(short targetId) {
        this.targetId = targetId;
    }

    @Override
    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    @Override
    public int getRetransmitCount() {
        return this.retransmitCount;
    }

    private void setRetransmitCount(int retransmitCount) {
        this.retransmitCount = retransmitCount;
    }
}

