/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.training.chains;

import lombok.NonNull;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.messages.Chain;
import org.nd4j.parameterserver.distributed.messages.VoidMessage;
import org.nd4j.parameterserver.distributed.messages.aggregations.DotAggregation;
import org.nd4j.parameterserver.distributed.messages.requests.CbowRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbowChain
implements Chain {
    private static final Logger log = LoggerFactory.getLogger(CbowChain.class);
    protected long originatorId;
    protected long taskId;
    protected long frameId;
    protected CbowRequestMessage cbowRequest;
    protected DotAggregation dotAggregation;

    public CbowChain(@NonNull CbowRequestMessage message) {
        this(message.getTaskId(), message);
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
    }

    public CbowChain(long taskId, @NonNull CbowRequestMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        this.taskId = taskId;
        this.originatorId = message.getOriginatorId();
        this.frameId = message.getFrameId();
    }

    @Override
    public void addElement(VoidMessage message) {
        if (message instanceof CbowRequestMessage) {
            this.cbowRequest = (CbowRequestMessage)message;
        } else if (message instanceof DotAggregation) {
            this.dotAggregation = (DotAggregation)message;
        } else {
            throw new ND4JIllegalStateException("Unknown message passed: " + message.getClass().getCanonicalName());
        }
    }

    @Override
    public long getOriginatorId() {
        return this.originatorId;
    }

    @Override
    public long getTaskId() {
        return this.taskId;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public CbowRequestMessage getCbowRequest() {
        return this.cbowRequest;
    }

    public DotAggregation getDotAggregation() {
        return this.dotAggregation;
    }

    public void setOriginatorId(long originatorId) {
        this.originatorId = originatorId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setFrameId(long frameId) {
        this.frameId = frameId;
    }

    public void setCbowRequest(CbowRequestMessage cbowRequest) {
        this.cbowRequest = cbowRequest;
    }

    public void setDotAggregation(DotAggregation dotAggregation) {
        this.dotAggregation = dotAggregation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CbowChain)) {
            return false;
        }
        CbowChain other = (CbowChain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOriginatorId() != other.getOriginatorId()) {
            return false;
        }
        if (this.getTaskId() != other.getTaskId()) {
            return false;
        }
        if (this.getFrameId() != other.getFrameId()) {
            return false;
        }
        CbowRequestMessage this$cbowRequest = this.getCbowRequest();
        CbowRequestMessage other$cbowRequest = other.getCbowRequest();
        if (this$cbowRequest == null ? other$cbowRequest != null : !((Object)this$cbowRequest).equals(other$cbowRequest)) {
            return false;
        }
        DotAggregation this$dotAggregation = this.getDotAggregation();
        DotAggregation other$dotAggregation = other.getDotAggregation();
        return !(this$dotAggregation == null ? other$dotAggregation != null : !((Object)this$dotAggregation).equals(other$dotAggregation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CbowChain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $originatorId = this.getOriginatorId();
        result = result * 59 + (int)($originatorId >>> 32 ^ $originatorId);
        long $taskId = this.getTaskId();
        result = result * 59 + (int)($taskId >>> 32 ^ $taskId);
        long $frameId = this.getFrameId();
        result = result * 59 + (int)($frameId >>> 32 ^ $frameId);
        CbowRequestMessage $cbowRequest = this.getCbowRequest();
        result = result * 59 + ($cbowRequest == null ? 43 : ((Object)$cbowRequest).hashCode());
        DotAggregation $dotAggregation = this.getDotAggregation();
        result = result * 59 + ($dotAggregation == null ? 43 : ((Object)$dotAggregation).hashCode());
        return result;
    }

    public String toString() {
        return "CbowChain(originatorId=" + this.getOriginatorId() + ", taskId=" + this.getTaskId() + ", frameId=" + this.getFrameId() + ", cbowRequest=" + this.getCbowRequest() + ", dotAggregation=" + this.getDotAggregation() + ")";
    }
}

