/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.training.chains;

import lombok.NonNull;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.messages.Chain;
import org.nd4j.parameterserver.distributed.messages.VoidMessage;
import org.nd4j.parameterserver.distributed.messages.aggregations.DotAggregation;
import org.nd4j.parameterserver.distributed.messages.requests.SkipGramRequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipGramChain
implements Chain {
    private static final Logger log = LoggerFactory.getLogger(SkipGramChain.class);
    protected long originatorId;
    protected long taskId;
    protected long frameId;
    protected SkipGramRequestMessage requestMessage;
    protected DotAggregation dotAggregation;

    public SkipGramChain(long originatorId, long taskId, long frameId) {
        this.taskId = taskId;
        this.frameId = frameId;
        this.originatorId = originatorId;
    }

    public SkipGramChain(@NonNull SkipGramRequestMessage message) {
        this(message.getTaskId(), message);
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
    }

    public SkipGramChain(long taskId, @NonNull SkipGramRequestMessage message) {
        this(message.getOriginatorId(), taskId, message.getFrameId());
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        this.addElement(message);
    }

    @Override
    public long getTaskId() {
        return this.taskId;
    }

    @Override
    public void addElement(VoidMessage message) {
        if (message instanceof SkipGramRequestMessage) {
            this.requestMessage = (SkipGramRequestMessage)message;
        } else if (message instanceof DotAggregation) {
            this.dotAggregation = (DotAggregation)message;
        } else {
            throw new ND4JIllegalStateException("Unknown message received: [" + message.getClass().getCanonicalName() + "]");
        }
    }

    @Override
    public long getOriginatorId() {
        return this.originatorId;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public SkipGramRequestMessage getRequestMessage() {
        return this.requestMessage;
    }

    public DotAggregation getDotAggregation() {
        return this.dotAggregation;
    }

    public void setOriginatorId(long originatorId) {
        this.originatorId = originatorId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setFrameId(long frameId) {
        this.frameId = frameId;
    }

    public void setRequestMessage(SkipGramRequestMessage requestMessage) {
        this.requestMessage = requestMessage;
    }

    public void setDotAggregation(DotAggregation dotAggregation) {
        this.dotAggregation = dotAggregation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkipGramChain)) {
            return false;
        }
        SkipGramChain other = (SkipGramChain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOriginatorId() != other.getOriginatorId()) {
            return false;
        }
        if (this.getTaskId() != other.getTaskId()) {
            return false;
        }
        if (this.getFrameId() != other.getFrameId()) {
            return false;
        }
        SkipGramRequestMessage this$requestMessage = this.getRequestMessage();
        SkipGramRequestMessage other$requestMessage = other.getRequestMessage();
        if (this$requestMessage == null ? other$requestMessage != null : !((Object)this$requestMessage).equals(other$requestMessage)) {
            return false;
        }
        DotAggregation this$dotAggregation = this.getDotAggregation();
        DotAggregation other$dotAggregation = other.getDotAggregation();
        return !(this$dotAggregation == null ? other$dotAggregation != null : !((Object)this$dotAggregation).equals(other$dotAggregation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SkipGramChain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $originatorId = this.getOriginatorId();
        result = result * 59 + (int)($originatorId >>> 32 ^ $originatorId);
        long $taskId = this.getTaskId();
        result = result * 59 + (int)($taskId >>> 32 ^ $taskId);
        long $frameId = this.getFrameId();
        result = result * 59 + (int)($frameId >>> 32 ^ $frameId);
        SkipGramRequestMessage $requestMessage = this.getRequestMessage();
        result = result * 59 + ($requestMessage == null ? 43 : ((Object)$requestMessage).hashCode());
        DotAggregation $dotAggregation = this.getDotAggregation();
        result = result * 59 + ($dotAggregation == null ? 43 : ((Object)$dotAggregation).hashCode());
        return result;
    }

    public String toString() {
        return "SkipGramChain(originatorId=" + this.getOriginatorId() + ", taskId=" + this.getTaskId() + ", frameId=" + this.getFrameId() + ", requestMessage=" + this.getRequestMessage() + ", dotAggregation=" + this.getDotAggregation() + ")";
    }
}

