/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.v2.transport.impl;

import lombok.NonNull;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.v2.transport.PortSupplier;

public class EnvironmentVarPortSupplier
implements PortSupplier {
    private int port = -1;
    private String variableName;

    protected EnvironmentVarPortSupplier() {
    }

    public EnvironmentVarPortSupplier(@NonNull String varName) {
        if (varName == null) {
            throw new NullPointerException("varName is marked @NonNull but is null");
        }
        this.variableName = varName;
    }

    @Override
    public int getPort() {
        String variable = System.getenv(this.variableName);
        if (variable == null) {
            throw new ND4JIllegalStateException("Unable to get networking port from environment variable: environment variable [" + this.variableName + "] isn't defined");
        }
        try {
            this.port = Integer.valueOf(variable);
        }
        catch (NumberFormatException e) {
            throw new ND4JIllegalStateException("Unable to get network port from environment variable: environment variable [" + this.variableName + "] contains bad value: [" + variable + "]");
        }
        Preconditions.checkState((this.port > 0 && this.port <= 65535 ? 1 : 0) != 0, (String)"Invalid port for environment variable: ports must bebetween 0 (exclusive) and 65535 (inclusive). Got port: %s", (int)this.port);
        return this.port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvironmentVarPortSupplier)) {
            return false;
        }
        EnvironmentVarPortSupplier other = (EnvironmentVarPortSupplier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$variableName = this.variableName;
        String other$variableName = other.variableName;
        return !(this$variableName == null ? other$variableName != null : !this$variableName.equals(other$variableName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnvironmentVarPortSupplier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $variableName = this.variableName;
        result = result * 59 + ($variableName == null ? 43 : $variableName.hashCode());
        return result;
    }

    public String toString() {
        return "EnvironmentVarPortSupplier(port=" + this.getPort() + ", variableName=" + this.variableName + ")";
    }
}

