/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.v2.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.nd4j.linalg.primitives.Atomic;
import org.nd4j.linalg.util.SerializationUtils;
import org.nd4j.parameterserver.distributed.enums.NodeStatus;
import org.nd4j.parameterserver.distributed.v2.enums.MeshBuildMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshOrganizer
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MeshOrganizer.class);
    private static final long serialVersionUID = 1L;
    private MeshBuildMode buildMode = MeshBuildMode.MESH;
    public static final int MAX_DOWNSTREAMS = 8;
    public static final int MAX_DEPTH = 5;
    private Node rootNode = new Node(true);
    private transient List<Node> sortedNodes = new ArrayList<Node>();
    private transient Map<String, Node> nodeMap = new HashMap<String, Node>();
    private long version = 0L;
    protected transient Queue<Node> fillQueue = new LinkedTransferQueue<Node>();

    public MeshOrganizer() {
        for (int e = 0; e < 8; ++e) {
            this.fillQueue.add(this.rootNode);
        }
    }

    @Deprecated
    public MeshOrganizer(@NonNull MeshBuildMode mode) {
        this();
        if (mode == null) {
            throw new NullPointerException("mode is marked @NonNull but is null");
        }
        this.buildMode = mode;
    }

    public long getVersion() {
        return this.version;
    }

    public Node addNode(@NonNull String ip) {
        if (ip == null) {
            throw new NullPointerException("ip is marked @NonNull but is null");
        }
        return this.addNode(ip, 40123);
    }

    public Node addNode(@NonNull String ip, @NonNull int port) {
        if (ip == null) {
            throw new NullPointerException("ip is marked @NonNull but is null");
        }
        Node node = Node.builder().id(ip).port(port).upstream(null).build();
        return this.addNode(node);
    }

    public MeshOrganizer clone() {
        byte[] b = SerializationUtils.toByteArray((Serializable)this);
        return (MeshOrganizer)SerializationUtils.fromByteArray((byte[])b);
    }

    public synchronized Node addNode(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        ++this.version;
        if (this.buildMode == MeshBuildMode.MESH) {
            Node candidate = this.fillQueue.poll();
            candidate.addDownstreamNode(node);
            for (int e = 0; e < 8; ++e) {
                this.fillQueue.add(node);
            }
            this.sortedNodes.add(node);
            Collections.sort(this.sortedNodes);
        } else {
            this.rootNode.addDownstreamNode(node);
        }
        this.nodeMap.put(node.getId(), node);
        return node;
    }

    public void markNodeOffline(@NonNull String ip) throws NoSuchElementException {
        if (ip == null) {
            throw new NullPointerException("ip is marked @NonNull but is null");
        }
        this.markNodeOffline(this.getNodeById(ip));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markNodeOffline(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        Node node2 = node;
        synchronized (node2) {
            node.status(NodeStatus.OFFLINE);
            for (Node n : node.getDownstreamNodes()) {
                this.remapNode(n);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeshOrganizer that = (MeshOrganizer)o;
        boolean bm = this.buildMode == that.buildMode;
        boolean rn = Objects.equals(this.rootNode, that.rootNode);
        return bm && rn;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buildMode, this.rootNode});
    }

    public void remapNode(@NonNull String ip) {
        if (ip == null) {
            throw new NullPointerException("ip is marked @NonNull but is null");
        }
        this.remapNode(this.getNodeById(ip));
    }

    public void remapNodeAndDownstreams(@NonNull String ip) {
        if (ip == null) {
            throw new NullPointerException("ip is marked @NonNull but is null");
        }
        this.remapNodeAndDownstreams(this.getNodeById(ip));
    }

    public synchronized void remapNodeAndDownstreams(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        ++this.version;
        node.setUpstreamNode(this.rootNode);
        for (Node n : node.getDownstreamNodes()) {
            this.rootNode.addDownstreamNode(n);
            node.removeFromDownstreams(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remapNode(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        ++this.version;
        if (this.buildMode == MeshBuildMode.MESH) {
            node.getUpstreamNode().removeFromDownstreams(node);
            boolean m = false;
            for (Node n : this.sortedNodes) {
                if (Objects.equals(n, node) || !n.status().equals((Object)NodeStatus.ONLINE)) continue;
                n.addDownstreamNode(node);
                m = true;
                break;
            }
            if (!m) {
                this.rootNode.addDownstreamNode(node);
            }
            MeshOrganizer meshOrganizer = this;
            synchronized (meshOrganizer) {
                Collections.sort(this.sortedNodes);
            }
        } else if (this.buildMode == MeshBuildMode.PLAIN) {
            // empty if block
        }
    }

    public void removeNode() {
        throw new UnsupportedOperationException();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        Collection<Node> desc = this.rootNode.getDescendantNodes();
        this.nodeMap = new HashMap<String, Node>();
        for (Node d : desc) {
            this.nodeMap.put(d.getId(), d);
        }
    }

    public boolean isKnownNode(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (this.rootNode.getId() == null) {
            return false;
        }
        if (this.rootNode.getId().equals(id)) {
            return true;
        }
        return this.nodeMap.containsKey(id);
    }

    public Node getUpstreamForNode(@NonNull String ip) throws NoSuchElementException {
        if (ip == null) {
            throw new NullPointerException("ip is marked @NonNull but is null");
        }
        Node node = this.getNodeById(ip);
        return node.getUpstreamNode();
    }

    public Collection<Node> getDownstreamsForNode(@NonNull String ip) throws NoSuchElementException {
        if (ip == null) {
            throw new NullPointerException("ip is marked @NonNull but is null");
        }
        Node node = this.getNodeById(ip);
        return node.getDownstreamNodes();
    }

    public long numberOfDescendantsOfNode() {
        return this.rootNode.numberOfDescendants();
    }

    public long totalNodes() {
        return this.rootNode.numberOfDescendants() + 1L;
    }

    protected long flatSize() {
        return this.nodeMap.size();
    }

    public Collection<Node> flatNodes() {
        return this.nodeMap.values();
    }

    public Node getNodeById(@NonNull String id) throws NoSuchElementException {
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (id.equals(this.rootNode.getId())) {
            return this.rootNode;
        }
        Node node = this.nodeMap.get(id);
        if (node == null) {
            log.info("Existing nodes: [{}]", this.flatNodes());
            throw new NoSuchElementException(id);
        }
        return node;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public static class Node
    implements Serializable,
    Comparable<Node> {
        private static final long serialVersionUID = 1L;
        private boolean rootNode;
        private String id;
        private int port;
        private Node upstream;
        private final List<Node> downstream = new CopyOnWriteArrayList<Node>();
        private AtomicInteger position = new AtomicInteger(0);
        private Atomic<NodeStatus> status;

        public synchronized NodeStatus status() {
            return (NodeStatus)((Object)this.status.get());
        }

        protected synchronized void status(@NonNull NodeStatus status) {
            if (status == null) {
                throw new NullPointerException("status is marked @NonNull but is null");
            }
            this.status.set((Serializable)((Object)status));
        }

        protected Node getNextCandidate(Node node) {
            if (this.downstream.size() == 0) {
                return this;
            }
            if (node == null) {
                return this.downstream.get(0);
            }
            boolean b = false;
            for (Node v : this.downstream) {
                if (b) {
                    return v;
                }
                if (!Objects.equals(node, v)) continue;
                b = true;
            }
            return null;
        }

        protected Node(boolean rootNode) {
            this.rootNode = rootNode;
        }

        public Node addDownstreamNode(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked @NonNull but is null");
            }
            this.downstream.add(node);
            node.setUpstreamNode(this);
            return node;
        }

        protected Node pushDownstreamNode(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked @NonNull but is null");
            }
            if (this.isRootNode()) {
                if (this.downstream.size() == 0) {
                    return this.addDownstreamNode(node);
                }
                for (Node d : this.downstream) {
                    if (d.numberOfDescendants() >= 40L) continue;
                    return d.pushDownstreamNode(node);
                }
                return this.addDownstreamNode(node);
            }
            int distance = this.distanceFromRoot();
            for (Node d : this.downstream) {
                if (d.numberOfDescendants() >= (long)(8 * (5 - distance))) continue;
                return d.pushDownstreamNode(node);
            }
            return this.addDownstreamNode(node);
        }

        protected Node setUpstreamNode(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked @NonNull but is null");
            }
            this.upstream = node;
            return node;
        }

        public Node getUpstreamNode() {
            return this.upstream;
        }

        public long numberOfDescendants() {
            AtomicLong cnt = new AtomicLong(this.downstream.size());
            for (Node n : this.downstream) {
                cnt.addAndGet(n.numberOfDescendants());
            }
            return cnt.get();
        }

        public long numberOfDownstreams() {
            return this.downstream.size();
        }

        public Collection<Node> getDownstreamNodes() {
            return this.downstream;
        }

        public Collection<Node> getDescendantNodes() {
            ArrayList<Node> result = new ArrayList<Node>(this.getDownstreamNodes());
            for (Node n : this.downstream) {
                result.addAll(n.getDescendantNodes());
            }
            return result;
        }

        public int distanceFromRoot() {
            if (this.upstream.isRootNode()) {
                return 1;
            }
            return this.upstream.distanceFromRoot() + 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            String rn = this.upstream == null ? "root" : this.upstream.getId();
            String on = node.upstream == null ? "root" : node.upstream.getId();
            return this.rootNode == node.rootNode && this.port == node.port && Objects.equals(this.id, node.id) && Objects.equals(this.downstream, node.downstream) && Objects.equals(this.status, node.status) && Objects.equals(rn, on);
        }

        public int hashCode() {
            return Objects.hash(this.upstream == null ? "root" : this.upstream.getId(), this.rootNode, this.id, this.port, this.downstream, this.status);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.downstream == null || this.downstream.size() == 0) {
                builder.append("none");
            } else {
                for (Node n : this.downstream) {
                    builder.append("[").append(n.getId()).append("], ");
                }
            }
            String strId = this.id == null ? "null" : this.id;
            String upstreamId = this.upstream == null ? "none" : this.upstream.getId();
            return "[ Id: [" + strId + "]; ]";
        }

        public void truncateDownstreams() {
            this.downstream.clear();
        }

        public synchronized void removeFromDownstreams(@NonNull Node node) {
            if (node == null) {
                throw new NullPointerException("node is marked @NonNull but is null");
            }
            boolean r = this.downstream.remove(node);
            if (!r) {
                throw new NoSuchElementException(node.getId());
            }
        }

        @Override
        public int compareTo(@NonNull Node o) {
            if (o == null) {
                throw new NullPointerException("o is marked @NonNull but is null");
            }
            return Long.compare(this.numberOfDownstreams(), o.numberOfDownstreams());
        }

        private static boolean $default$rootNode() {
            return false;
        }

        private static Atomic<NodeStatus> $default$status() {
            return new Atomic((Serializable)((Object)NodeStatus.ONLINE));
        }

        public static NodeBuilder builder() {
            return new NodeBuilder();
        }

        public Node() {
            this.rootNode = Node.$default$rootNode();
            this.status = Node.$default$status();
        }

        public Node(boolean rootNode, String id, int port, Node upstream, AtomicInteger position, Atomic<NodeStatus> status) {
            this.rootNode = rootNode;
            this.id = id;
            this.port = port;
            this.upstream = upstream;
            this.position = position;
            this.status = status;
        }

        public boolean isRootNode() {
            return this.rootNode;
        }

        protected void setRootNode(boolean rootNode) {
            this.rootNode = rootNode;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public static class NodeBuilder {
            private boolean rootNode$set;
            private boolean rootNode;
            private String id;
            private int port;
            private Node upstream;
            private AtomicInteger position;
            private boolean status$set;
            private Atomic<NodeStatus> status;

            NodeBuilder() {
            }

            public NodeBuilder rootNode(boolean rootNode) {
                this.rootNode = rootNode;
                this.rootNode$set = true;
                return this;
            }

            public NodeBuilder id(String id) {
                this.id = id;
                return this;
            }

            public NodeBuilder port(int port) {
                this.port = port;
                return this;
            }

            public NodeBuilder upstream(Node upstream) {
                this.upstream = upstream;
                return this;
            }

            public NodeBuilder position(AtomicInteger position) {
                this.position = position;
                return this;
            }

            public NodeBuilder status(Atomic<NodeStatus> status) {
                this.status = status;
                this.status$set = true;
                return this;
            }

            public Node build() {
                boolean rootNode = this.rootNode;
                if (!this.rootNode$set) {
                    rootNode = Node.$default$rootNode();
                }
                Atomic status = this.status;
                if (!this.status$set) {
                    status = Node.$default$status();
                }
                return new Node(rootNode, this.id, this.port, this.upstream, this.position, (Atomic<NodeStatus>)status);
            }

            public String toString() {
                return "MeshOrganizer.Node.NodeBuilder(rootNode=" + this.rootNode + ", id=" + this.id + ", port=" + this.port + ", upstream=" + this.upstream + ", position=" + this.position + ", status=" + this.status + ")";
            }
        }
    }
}

