/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.support.schema_name;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SchemaNames {
    private static final String ESCAPED_UNICODE_BACKTICK = "\\u0060";
    private static final Pattern PATTERN_ESCAPED_4DIGIT_UNICODE = Pattern.compile("\\\\u+(\\p{XDigit}{4})");
    private static final Pattern PATTERN_LABEL_AND_TYPE_QUOTATION = Pattern.compile("(?<!`)`(?:`{2})*(?!`)");
    private static final List<String[]> SUPPORTED_ESCAPE_CHARS = List.of(new String[]{"\\b", "\b"}, new String[]{"\\f", "\f"}, new String[]{"\\n", "\n"}, new String[]{"\\r", "\r"}, new String[]{"\\t", "\t"}, new String[]{"\\`", "``"});
    private static final int CACHE_SIZE = 128;
    private static final Map<CacheKey, SchemaName> CACHE = Collections.synchronizedMap(new LinkedHashMap<CacheKey, SchemaName>(32, 0.75f, true){
        private static final long serialVersionUID = -8109893585632797360L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<CacheKey, SchemaName> eldest) {
            return this.size() >= 128;
        }
    });

    public static Optional<String> sanitize(String value) {
        return SchemaNames.sanitize(value, false);
    }

    public static Optional<String> sanitize(String value, boolean enforceQuotes) {
        return SchemaNames.sanitize(value, enforceQuotes, -1, -1);
    }

    public static Optional<String> sanitize(String value, boolean enforceQuotes, int major, int minor) {
        if (major >= 0 && (major < 3 || major > 6)) {
            throw new IllegalArgumentException("Unsupported major version: " + major);
        }
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        CacheKey cacheKey = new CacheKey(value, major < 0 ? -1 : major, minor < 0 ? -1 : minor);
        SchemaName escapedValue = CACHE.computeIfAbsent(cacheKey, SchemaNames::sanitze);
        if (!enforceQuotes && !escapedValue.needsQuotation) {
            return Optional.of(escapedValue.value);
        }
        return Optional.of(String.format(Locale.ENGLISH, "`%s`", escapedValue.value));
    }

    private static SchemaName sanitze(CacheKey key) {
        String workingValue = key.value;
        for (String[] pair : SUPPORTED_ESCAPE_CHARS) {
            workingValue = workingValue.replace(pair[0], pair[1]);
        }
        workingValue = workingValue.replace(ESCAPED_UNICODE_BACKTICK, "`");
        Matcher matcher = PATTERN_ESCAPED_4DIGIT_UNICODE.matcher(workingValue);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String replacement = Character.toString((char)Integer.parseInt(matcher.group(1), 16));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        workingValue = sb.toString();
        if (SchemaNames.substituteRemainingEscapedUnicodeLiteral(key.major, key.minor)) {
            workingValue = workingValue.replace("\\u", "\\u005C\\u0075");
        }
        matcher = PATTERN_LABEL_AND_TYPE_QUOTATION.matcher(workingValue);
        workingValue = matcher.replaceAll("`$0");
        if (SchemaNames.unescapeEscapedBackslashes(key.major)) {
            workingValue = workingValue.replace("\\\\", "\\");
        }
        return new SchemaName(workingValue, !SchemaNames.isIdentifier(workingValue));
    }

    private static boolean substituteRemainingEscapedUnicodeLiteral(int major, int minor) {
        if (major == -1) {
            return true;
        }
        return major >= 4 && major <= 5 && (minor == -1 || minor >= 2);
    }

    private static boolean unescapeEscapedBackslashes(int major) {
        return major <= 5;
    }

    private static boolean isIdentifier(CharSequence name) {
        String id = name.toString();
        int cp = id.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < id.length(); i += Character.charCount(cp)) {
            cp = id.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    private SchemaNames() {
    }

    private static class CacheKey {
        private final String value;
        private final int major;
        private final int minor;

        CacheKey(String value, int major, int minor) {
            this.value = value;
            this.major = major;
            this.minor = minor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.major == cacheKey.major && this.minor == cacheKey.minor && this.value.equals(cacheKey.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.major, this.minor);
        }
    }

    private record SchemaName(String value, boolean needsQuotation) {
    }
}

