/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.util.Collection;
import java.util.Collections;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import org.neo4j.helpers.Service;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.internal.KernelData;

public abstract class ManagementBeanProvider
extends Service {
    final Class<?> beanInterface;

    public ManagementBeanProvider(Class<?> beanInterface) {
        super(ManagementSupport.beanName(beanInterface), new String[0]);
        if (DynamicMBean.class.isAssignableFrom(beanInterface)) {
            beanInterface = DynamicMBean.class;
        }
        this.beanInterface = beanInterface;
    }

    protected Iterable<? extends Neo4jMBean> createMBeans(ManagementData management) throws NotCompliantMBeanException {
        return ManagementBeanProvider.singletonOrNone(this.createMBean(management));
    }

    protected Iterable<? extends Neo4jMBean> createMXBeans(ManagementData management) throws NotCompliantMBeanException {
        Class implClass;
        try {
            implClass = ((Object)((Object)this)).getClass().getDeclaredMethod("createMBeans", ManagementData.class).getDeclaringClass();
        }
        catch (Exception e) {
            implClass = ManagementBeanProvider.class;
        }
        if (implClass != ManagementBeanProvider.class) {
            return this.createMBeans(management);
        }
        return ManagementBeanProvider.singletonOrNone(this.createMXBean(management));
    }

    protected abstract Neo4jMBean createMBean(ManagementData var1) throws NotCompliantMBeanException;

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        return this.createMBean(management);
    }

    final Iterable<? extends Neo4jMBean> loadBeans(KernelData kernel, ManagementSupport support) throws Exception {
        if (support.supportsMxBeans()) {
            return this.createMXBeans(new ManagementData(this, kernel, support));
        }
        return this.createMBeans(new ManagementData(this, kernel, support));
    }

    private static Collection<? extends Neo4jMBean> singletonOrNone(Neo4jMBean mbean) {
        if (mbean == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(mbean);
    }
}

