/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;

public class DefaultParameterValue {
    private final Object value;
    private final Neo4jTypes.AnyType type;

    public DefaultParameterValue(Object value, Neo4jTypes.AnyType type) {
        this.value = value;
        this.type = type;
    }

    public Object value() {
        return this.value;
    }

    public Neo4jTypes.AnyType neo4jType() {
        return this.type;
    }

    public static DefaultParameterValue ntString(String value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTString);
    }

    public static DefaultParameterValue ntInteger(long value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTInteger);
    }

    public static DefaultParameterValue ntFloat(double value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTFloat);
    }

    public static DefaultParameterValue ntBoolean(boolean value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTBoolean);
    }

    public static DefaultParameterValue ntMap(Map<String, Object> value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTMap);
    }

    public static DefaultParameterValue ntByteArray(byte[] value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTByteArray);
    }

    public static DefaultParameterValue ntList(List<?> value, Neo4jTypes.AnyType inner) {
        return new DefaultParameterValue(value, Neo4jTypes.NTList(inner));
    }

    public static DefaultParameterValue nullValue(Neo4jTypes.AnyType type) {
        return new DefaultParameterValue(null, type);
    }

    public String toString() {
        return "DefaultParameterValue{value=" + this.value + ", type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultParameterValue that = (DefaultParameterValue)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

