/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;
import org.noear.solon.serialization.snack3.SnackRenderFactoryBase;

public class SnackRenderFactory
extends SnackRenderFactoryBase {
    public SnackRenderFactory(JsonProps jsonProps) {
        this.serializer.setConfig(Options.def());
        this.addFeatures(Feature.EnumUsingName);
        this.applyProps(jsonProps);
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    public Render create() {
        return new StringSerializerRender(false, (ContextSerializer)this.serializer);
    }

    public void setFeatures(Feature ... features) {
        this.config().setFeatures(features);
    }

    public void addFeatures(Feature ... features) {
        this.config().add(features);
    }

    public void removeFeatures(Feature ... features) {
        this.config().remove(features);
    }

    protected void applyProps(JsonProps jsonProps) {
        if (JsonPropsUtil.apply((JsonRenderFactory)this, (JsonProps)jsonProps)) {
            if (jsonProps.longAsString) {
                this.addConvertor(Long.class, String::valueOf);
                this.addConvertor(Long.TYPE, String::valueOf);
            }
            if (jsonProps.nullStringAsEmpty) {
                this.addFeatures(Feature.StringNullAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                this.addFeatures(Feature.BooleanNullAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                this.addFeatures(Feature.NumberNullAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.addFeatures(Feature.ArrayNullAsEmpty);
            }
            if (jsonProps.nullAsWriteable) {
                this.addFeatures(Feature.SerializeNulls);
            }
            if (jsonProps.enumAsName) {
                this.addFeatures(Feature.EnumUsingName);
            }
        }
    }
}

