/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class ByteConverter {
    private static final int NUMERIC_DSCALE_MASK = 16383;
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short NUMERIC_NAN = -16384;
    private static final int SHORT_BYTES = 2;
    private static final int[] INT_TEN_POWERS = new int[6];
    private static final BigInteger[] BI_TEN_POWERS = new BigInteger[32];
    private static final BigInteger BI_TEN_THOUSAND = BigInteger.valueOf(10000L);

    private ByteConverter() {
    }

    public static Number numeric(byte[] bytes) {
        return ByteConverter.numeric(bytes, 0, bytes.length);
    }

    public static Number numeric(byte[] bytes, int pos, int numBytes) {
        if (numBytes < 8) {
            throw new IllegalArgumentException("number of bytes should be at-least 8");
        }
        int len = ByteConverter.int2(bytes, pos) & 0xFFFF;
        int weight = ByteConverter.int2(bytes, pos + 2);
        short sign = ByteConverter.int2(bytes, pos + 4);
        int scale = ByteConverter.int2(bytes, pos + 6);
        if (numBytes != len * 2 + 8) {
            throw new IllegalArgumentException("invalid length of bytes \"numeric\" value");
        }
        if (sign != 0 && sign != 16384 && sign != -16384) {
            throw new IllegalArgumentException("invalid sign in \"numeric\" value");
        }
        if (sign == -16384) {
            return Double.NaN;
        }
        if ((scale & 0x3FFF) != scale) {
            throw new IllegalArgumentException("invalid scale in \"numeric\" value");
        }
        if (len == 0) {
            return new BigDecimal(BigInteger.ZERO, scale);
        }
        int idx = pos + 8;
        short d = ByteConverter.int2(bytes, idx);
        if (weight < 0) {
            int i;
            assert (scale > 0);
            int effectiveScale = scale;
            if ((weight = (short)(weight + 1)) < 0) {
                effectiveScale += 4 * weight;
            }
            for (i = 1; i < len && d == 0; ++i) {
                effectiveScale -= 4;
                d = ByteConverter.int2(bytes, idx += 2);
            }
            assert (effectiveScale > 0);
            if (effectiveScale >= 4) {
                effectiveScale -= 4;
            } else {
                d = (short)(d / INT_TEN_POWERS[4 - effectiveScale]);
                effectiveScale = 0;
            }
            BigInteger unscaledBI = null;
            long unscaledInt = d;
            while (i < len) {
                if (i == 4 && effectiveScale > 2) {
                    unscaledBI = BigInteger.valueOf(unscaledInt);
                }
                d = ByteConverter.int2(bytes, idx += 2);
                if (effectiveScale >= 4) {
                    if (unscaledBI == null) {
                        unscaledInt *= 10000L;
                    } else {
                        unscaledBI = unscaledBI.multiply(BI_TEN_THOUSAND);
                    }
                    effectiveScale -= 4;
                } else {
                    if (unscaledBI == null) {
                        unscaledInt *= (long)INT_TEN_POWERS[effectiveScale];
                    } else {
                        unscaledBI = unscaledBI.multiply(ByteConverter.tenPower(effectiveScale));
                    }
                    d = (short)(d / INT_TEN_POWERS[4 - effectiveScale]);
                    effectiveScale = 0;
                }
                if (unscaledBI == null) {
                    unscaledInt += (long)d;
                } else if (d != 0) {
                    unscaledBI = unscaledBI.add(BigInteger.valueOf(d));
                }
                ++i;
            }
            if (unscaledBI == null) {
                unscaledBI = BigInteger.valueOf(unscaledInt);
            }
            if (effectiveScale > 0) {
                unscaledBI = unscaledBI.multiply(ByteConverter.tenPower(effectiveScale));
            }
            if (sign == 16384) {
                unscaledBI = unscaledBI.negate();
            }
            return new BigDecimal(unscaledBI, scale);
        }
        if (scale == 0) {
            int bigDecScale;
            BigInteger unscaledBI = null;
            long unscaledInt = d;
            for (int i = 1; i < len; ++i) {
                if (i == 4) {
                    unscaledBI = BigInteger.valueOf(unscaledInt);
                }
                d = ByteConverter.int2(bytes, idx += 2);
                if (unscaledBI == null) {
                    unscaledInt *= 10000L;
                    unscaledInt += (long)d;
                    continue;
                }
                unscaledBI = unscaledBI.multiply(BI_TEN_THOUSAND);
                if (d == 0) continue;
                unscaledBI = unscaledBI.add(BigInteger.valueOf(d));
            }
            if (unscaledBI == null) {
                unscaledBI = BigInteger.valueOf(unscaledInt);
            }
            if (sign == 16384) {
                unscaledBI = unscaledBI.negate();
            }
            return (bigDecScale = (len - (weight + 1)) * 4) == 0 ? new BigDecimal(unscaledBI) : new BigDecimal(unscaledBI, bigDecScale).setScale(0);
        }
        BigInteger unscaledBI = null;
        long unscaledInt = d;
        int effectiveWeight = weight;
        int effectiveScale = scale;
        for (int i = 1; i < len; ++i) {
            if (i == 4) {
                unscaledBI = BigInteger.valueOf(unscaledInt);
            }
            d = ByteConverter.int2(bytes, idx += 2);
            if (effectiveWeight > 0) {
                --effectiveWeight;
                if (unscaledBI == null) {
                    unscaledInt *= 10000L;
                } else {
                    unscaledBI = unscaledBI.multiply(BI_TEN_THOUSAND);
                }
            } else if (effectiveScale >= 4) {
                effectiveScale -= 4;
                if (unscaledBI == null) {
                    unscaledInt *= 10000L;
                } else {
                    unscaledBI = unscaledBI.multiply(BI_TEN_THOUSAND);
                }
            } else {
                if (unscaledBI == null) {
                    unscaledInt *= (long)INT_TEN_POWERS[effectiveScale];
                } else {
                    unscaledBI = unscaledBI.multiply(ByteConverter.tenPower(effectiveScale));
                }
                d = (short)(d / INT_TEN_POWERS[4 - effectiveScale]);
                effectiveScale = 0;
            }
            if (unscaledBI == null) {
                unscaledInt += (long)d;
                continue;
            }
            if (d == 0) continue;
            unscaledBI = unscaledBI.add(BigInteger.valueOf(d));
        }
        if (unscaledBI == null) {
            unscaledBI = BigInteger.valueOf(unscaledInt);
        }
        if (effectiveWeight > 0) {
            unscaledBI = unscaledBI.multiply(ByteConverter.tenPower(effectiveWeight * 4));
        }
        if (effectiveScale > 0) {
            unscaledBI = unscaledBI.multiply(ByteConverter.tenPower(effectiveScale));
        }
        if (sign == 16384) {
            unscaledBI = unscaledBI.negate();
        }
        return new BigDecimal(unscaledBI, scale);
    }

    private static BigInteger tenPower(int exponent) {
        return BI_TEN_POWERS.length > exponent ? BI_TEN_POWERS[exponent] : BigInteger.TEN.pow(exponent);
    }

    public static long int8(byte[] bytes, int idx) {
        return ((long)(bytes[idx + 0] & 0xFF) << 56) + ((long)(bytes[idx + 1] & 0xFF) << 48) + ((long)(bytes[idx + 2] & 0xFF) << 40) + ((long)(bytes[idx + 3] & 0xFF) << 32) + ((long)(bytes[idx + 4] & 0xFF) << 24) + ((long)(bytes[idx + 5] & 0xFF) << 16) + ((long)(bytes[idx + 6] & 0xFF) << 8) + (long)(bytes[idx + 7] & 0xFF);
    }

    public static int int4(byte[] bytes, int idx) {
        return ((bytes[idx] & 0xFF) << 24) + ((bytes[idx + 1] & 0xFF) << 16) + ((bytes[idx + 2] & 0xFF) << 8) + (bytes[idx + 3] & 0xFF);
    }

    public static short int2(byte[] bytes, int idx) {
        return (short)(((bytes[idx] & 0xFF) << 8) + (bytes[idx + 1] & 0xFF));
    }

    public static boolean bool(byte[] bytes, int idx) {
        return bytes[idx] == 1;
    }

    public static float float4(byte[] bytes, int idx) {
        return Float.intBitsToFloat(ByteConverter.int4(bytes, idx));
    }

    public static double float8(byte[] bytes, int idx) {
        return Double.longBitsToDouble(ByteConverter.int8(bytes, idx));
    }

    public static void int8(byte[] target, int idx, long value) {
        target[idx + 0] = (byte)(value >>> 56);
        target[idx + 1] = (byte)(value >>> 48);
        target[idx + 2] = (byte)(value >>> 40);
        target[idx + 3] = (byte)(value >>> 32);
        target[idx + 4] = (byte)(value >>> 24);
        target[idx + 5] = (byte)(value >>> 16);
        target[idx + 6] = (byte)(value >>> 8);
        target[idx + 7] = (byte)value;
    }

    public static void int4(byte[] target, int idx, int value) {
        target[idx + 0] = (byte)(value >>> 24);
        target[idx + 1] = (byte)(value >>> 16);
        target[idx + 2] = (byte)(value >>> 8);
        target[idx + 3] = (byte)value;
    }

    public static void int2(byte[] target, int idx, int value) {
        target[idx + 0] = (byte)(value >>> 8);
        target[idx + 1] = (byte)value;
    }

    public static void bool(byte[] target, int idx, boolean value) {
        target[idx] = value ? (byte)1 : 0;
    }

    public static void float4(byte[] target, int idx, float value) {
        ByteConverter.int4(target, idx, Float.floatToRawIntBits(value));
    }

    public static void float8(byte[] target, int idx, double value) {
        ByteConverter.int8(target, idx, Double.doubleToRawLongBits(value));
    }
}

