/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.redisson.api.RMapCache;

public class RedissonStorage
implements DomainDataStorageAccess {
    private final RMapCache<Object, Object> mapCache;
    int ttl;
    int maxIdle;

    public RedissonStorage(RMapCache<Object, Object> mapCache, Map<String, Object> properties, String defaultKey) {
        String maxIdleTime;
        String timeToLive;
        this.mapCache = mapCache;
        String maxEntries = this.getProperty(properties, mapCache.getName(), defaultKey, ".eviction.max_entries");
        if (maxEntries != null) {
            mapCache.setMaxSize(Integer.valueOf(maxEntries).intValue());
        }
        if ((timeToLive = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.time_to_live")) != null) {
            this.ttl = Integer.valueOf(timeToLive);
        }
        if ((maxIdleTime = this.getProperty(properties, mapCache.getName(), defaultKey, ".expiration.max_idle_time")) != null) {
            this.maxIdle = Integer.valueOf(maxIdleTime);
        }
    }

    private String getProperty(Map<String, Object> properties, String name, String defaultKey, String suffix) {
        String maxEntries = (String)properties.get("hibernate.cache.redisson." + name + suffix);
        if (maxEntries != null) {
            return maxEntries;
        }
        String defValue = (String)properties.get("hibernate.cache.redisson." + defaultKey + suffix);
        if (defValue != null) {
            return defValue;
        }
        return null;
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        return this.mapCache.get(key);
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        this.mapCache.fastPut(key, value, (long)this.ttl, TimeUnit.MILLISECONDS, (long)this.maxIdle, TimeUnit.MILLISECONDS);
    }

    public boolean contains(Object key) {
        return this.mapCache.containsKey(key);
    }

    public void evictData() {
        this.mapCache.clear();
    }

    public void evictData(Object key) {
        this.mapCache.fastRemove(new Object[]{key});
    }

    public void release() {
        this.mapCache.destroy();
    }
}

