/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedisClusterNodeDecoder;
import org.redisson.spring.data.connection.RedissonReactiveClusterGeoCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterHashCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterHyperLogLogCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterKeyCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterListCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterNumberCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterServerCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterSetCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterStreamCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterStringCommands;
import org.redisson.spring.data.connection.RedissonReactiveClusterZSetCommands;
import org.redisson.spring.data.connection.RedissonReactiveRedisConnection;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.ReactiveClusterCommands;
import org.springframework.data.redis.connection.ReactiveClusterGeoCommands;
import org.springframework.data.redis.connection.ReactiveClusterHashCommands;
import org.springframework.data.redis.connection.ReactiveClusterHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveClusterKeyCommands;
import org.springframework.data.redis.connection.ReactiveClusterListCommands;
import org.springframework.data.redis.connection.ReactiveClusterNumberCommands;
import org.springframework.data.redis.connection.ReactiveClusterServerCommands;
import org.springframework.data.redis.connection.ReactiveClusterSetCommands;
import org.springframework.data.redis.connection.ReactiveClusterStreamCommands;
import org.springframework.data.redis.connection.ReactiveClusterStringCommands;
import org.springframework.data.redis.connection.ReactiveClusterZSetCommands;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class RedissonReactiveRedisClusterConnection
extends RedissonReactiveRedisConnection
implements ReactiveRedisClusterConnection {
    private static final RedisStrictCommand<List<RedisClusterNode>> CLUSTER_NODES = new RedisStrictCommand("CLUSTER", "NODES", (MultiDecoder)new ObjectDecoder((Decoder)new RedisClusterNodeDecoder()));
    private static final RedisStrictCommand<List<String>> CLUSTER_GETKEYSINSLOT = new RedisStrictCommand("CLUSTER", "GETKEYSINSLOT", (MultiDecoder)new ObjectListReplayDecoder());

    public RedissonReactiveRedisClusterConnection(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public ReactiveClusterKeyCommands keyCommands() {
        return new RedissonReactiveClusterKeyCommands(this.executorService);
    }

    public ReactiveClusterStringCommands stringCommands() {
        return new RedissonReactiveClusterStringCommands(this.executorService);
    }

    public ReactiveClusterNumberCommands numberCommands() {
        return new RedissonReactiveClusterNumberCommands(this.executorService);
    }

    public ReactiveClusterListCommands listCommands() {
        return new RedissonReactiveClusterListCommands(this.executorService);
    }

    public ReactiveClusterSetCommands setCommands() {
        return new RedissonReactiveClusterSetCommands(this.executorService);
    }

    public ReactiveClusterZSetCommands zSetCommands() {
        return new RedissonReactiveClusterZSetCommands(this.executorService);
    }

    public ReactiveClusterHashCommands hashCommands() {
        return new RedissonReactiveClusterHashCommands(this.executorService);
    }

    public ReactiveClusterGeoCommands geoCommands() {
        return new RedissonReactiveClusterGeoCommands(this.executorService);
    }

    public ReactiveClusterHyperLogLogCommands hyperLogLogCommands() {
        return new RedissonReactiveClusterHyperLogLogCommands(this.executorService);
    }

    public ReactiveClusterServerCommands serverCommands() {
        return new RedissonReactiveClusterServerCommands(this.executorService);
    }

    public ReactiveClusterStreamCommands streamCommands() {
        return new RedissonReactiveClusterStreamCommands(this.executorService);
    }

    public Mono<String> ping(RedisClusterNode node) {
        return this.execute(node, RedisCommands.PING, new Object[0]);
    }

    public Flux<RedisClusterNode> clusterGetNodes() {
        Mono result = this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)CLUSTER_NODES, new Object[0]);
        return result.flatMapMany(e -> Flux.fromIterable((Iterable)e));
    }

    public Flux<RedisClusterNode> clusterGetReplicas(RedisClusterNode redisClusterNode) {
        Flux<RedisClusterNode> nodes = this.clusterGetNodes();
        Flux master = nodes.filter(e -> e.getHost().equals(redisClusterNode.getHost()) && e.getPort().equals(redisClusterNode.getPort()));
        return master.flatMap(node -> this.clusterGetNodes().filter(e -> Objects.equals(e.getMasterId(), node.getMasterId())));
    }

    public Mono<Map<RedisClusterNode, Collection<RedisClusterNode>>> clusterGetMasterReplicaMap() {
        Flux<RedisClusterNode> nodes = this.clusterGetNodes();
        Flux masters = nodes.filter(e -> e.isMaster());
        return masters.flatMap(master -> Mono.just((Object)master).zipWith(this.clusterGetNodes().filter(e -> Objects.equals(e.getMasterId(), master.getMasterId())).collect(Collectors.toSet()))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2));
    }

    public Mono<Integer> clusterGetSlotForKey(ByteBuffer byteBuffer) {
        return this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.KEYSLOT, new Object[]{RedissonReactiveRedisClusterConnection.toByteArray(byteBuffer)});
    }

    public Mono<RedisClusterNode> clusterGetNodeForSlot(int slot) {
        return this.clusterGetNodes().filter(n -> n.isMaster() && n.getSlotRange().contains(slot)).next();
    }

    public Mono<RedisClusterNode> clusterGetNodeForKey(ByteBuffer byteBuffer) {
        int slot = this.executorService.getConnectionManager().calcSlot(RedissonReactiveRedisClusterConnection.toByteArray(byteBuffer));
        return this.clusterGetNodeForSlot(slot);
    }

    public Mono<ClusterInfo> clusterGetClusterInfo() {
        Mono mono = this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.CLUSTER_INFO, new Object[0]);
        return mono.map(e -> {
            Properties props = new Properties();
            for (Map.Entry entry : e.entrySet()) {
                props.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return new ClusterInfo(props);
        });
    }

    public Mono<Void> clusterAddSlots(RedisClusterNode redisClusterNode, int ... ints) {
        List<Integer> params = this.convert(ints);
        return this.execute(redisClusterNode, RedisCommands.CLUSTER_ADDSLOTS, params.toArray());
    }

    private List<Integer> convert(int ... slots) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        for (int slot : slots) {
            params.add(slot);
        }
        return params;
    }

    public Mono<Void> clusterAddSlots(RedisClusterNode redisClusterNode, RedisClusterNode.SlotRange slotRange) {
        return this.clusterAddSlots(redisClusterNode, slotRange.getSlotsArray());
    }

    public Mono<Long> clusterCountKeysInSlot(int slot) {
        Mono<RedisClusterNode> node = this.clusterGetNodeForSlot(slot);
        return node.flatMap(e -> this.execute((RedisClusterNode)e, RedisCommands.CLUSTER_COUNTKEYSINSLOT, new Object[]{slot}));
    }

    public Mono<Void> clusterDeleteSlots(RedisClusterNode redisClusterNode, int ... ints) {
        List<Integer> params = this.convert(ints);
        return this.execute(redisClusterNode, RedisCommands.CLUSTER_DELSLOTS, params.toArray());
    }

    public Mono<Void> clusterDeleteSlotsInRange(RedisClusterNode redisClusterNode, RedisClusterNode.SlotRange slotRange) {
        return this.clusterDeleteSlots(redisClusterNode, slotRange.getSlotsArray());
    }

    public Mono<Void> clusterForget(RedisClusterNode redisClusterNode) {
        return this.execute(redisClusterNode, RedisCommands.CLUSTER_FORGET, new Object[]{redisClusterNode.getId()});
    }

    public Mono<Void> clusterMeet(RedisClusterNode redisClusterNode) {
        return this.execute(redisClusterNode, RedisCommands.CLUSTER_MEET, new Object[]{redisClusterNode.getHost(), redisClusterNode.getPort()});
    }

    public Mono<Void> clusterSetSlot(RedisClusterNode redisClusterNode, int slot, ReactiveClusterCommands.AddSlots addSlots) {
        return this.execute(redisClusterNode, RedisCommands.CLUSTER_SETSLOT, new Object[]{slot, addSlots});
    }

    public Flux<ByteBuffer> clusterGetKeysInSlot(int slot, int count) {
        Mono f = this.executorService.reactive(() -> this.executorService.readAsync((String)null, (Codec)ByteArrayCodec.INSTANCE, CLUSTER_GETKEYSINSLOT, new Object[]{slot, count}));
        return f.flatMapMany(e -> Flux.fromIterable((Iterable)e)).map(e -> ByteBuffer.wrap(e));
    }

    public Mono<Void> clusterReplicate(RedisClusterNode redisClusterNode, RedisClusterNode slave) {
        return this.execute(redisClusterNode, RedisCommands.CLUSTER_REPLICATE, new Object[]{slave.getId()});
    }
}

