/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.revapi.API;
import org.revapi.AnalysisResult;
import org.revapi.Archive;
import org.revapi.CompatibilityType;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.maven.Analyzer;
import org.revapi.maven.AnalyzerBuilder;
import org.revapi.maven.FailSeverity;
import org.revapi.maven.ReportTimeReporter;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ReportMojo
extends AbstractMavenReport {
    @Parameter(property="", defaultValue="")
    protected PlexusConfiguration pipelineConfiguration;
    @Parameter(property="", defaultValue="")
    protected PlexusConfiguration analysisConfiguration;
    @Parameter(property="revapi.analysisConfigurationFiles", defaultValue="")
    protected Object[] analysisConfigurationFiles;
    @Parameter(property="revapi.failOnMissingConfigurationFiles", defaultValue="true")
    protected boolean failOnMissingConfigurationFiles;
    @Parameter(property="revapi.oldArtifacts", defaultValue="")
    protected String[] oldArtifacts;
    @Parameter(property="revapi.oldVersion", defaultValue="RELEASE")
    protected String oldVersion;
    @Parameter(property="revapi.newArtifacts", defaultValue="")
    protected String[] newArtifacts;
    @Parameter(property="revapi.newVersion", defaultValue="${project.version}")
    protected String newVersion;
    @Parameter(property="revapi.reportSeverity", defaultValue="potentiallyBreaking")
    protected FailSeverity reportSeverity;
    @Parameter(property="revapi.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="revapi.outputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true, readonly=true)
    protected String outputDirectory;
    @Parameter(property="revapi.checkDependencies", defaultValue="true")
    protected boolean checkDependencies;
    @Parameter(property="revapi.resolveProvidedDependencies", defaultValue="true")
    protected boolean resolveProvidedDependencies;
    @Parameter(property="revapi.resolveTransitiveProvidedDependencies", defaultValue="false")
    protected boolean resolveTransitiveProvidedDependencies;
    @Parameter(property="revapi.versionFormat", defaultValue="")
    protected String versionFormat;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(property="revapi.alwaysCheckForReleaseVersion", defaultValue="true")
    protected boolean alwaysCheckForReleaseVersion;
    @Parameter(property="revapi.failOnUnresolvedArtifacts", defaultValue="false")
    protected boolean failOnUnresolvedArtifacts;
    @Parameter(property="revapi.failOnUnresolvedDependencies", defaultValue="false")
    protected boolean failOnUnresolvedDependencies;
    @Parameter(property="revapi.generateSiteReport", defaultValue="true")
    protected boolean generateSiteReport;
    @Parameter(property="revapi.disallowedExtensions", defaultValue="")
    protected String disallowedExtensions;
    private API oldAPI;
    private API newAPI;
    private AnalysisResult analysisResult;

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public boolean canGenerateReport() {
        return this.project.getArtifact().getArtifactHandler().isAddedToClasspath();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.ensureAnalyzed(locale);
        if (this.skip) {
            return;
        }
        if (this.oldAPI == null || this.newAPI == null) {
            this.getLog().warn((CharSequence)"Could not determine the artifacts to compare. If you're comparing the currently built version, have you run the package goal?");
            return;
        }
        if (this.generateSiteReport) {
            Sink sink = this.getSink();
            ResourceBundle bundle = this.getBundle(locale);
            ReportTimeReporter reporter = (ReportTimeReporter)this.analysisResult.getExtensions().getFirstExtension(ReportTimeReporter.class, null);
            this.startReport(sink, bundle);
            this.reportBody(reporter, this.oldAPI, this.newAPI, sink, bundle);
            this.endReport(sink);
        }
    }

    protected void startReport(Sink sink, ResourceBundle messages) {
        sink.head();
        sink.title();
        sink.text(messages.getString("report.revapi.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.rawText(messages.getString("report.revapi.title"));
        sink.sectionTitle1_();
    }

    protected void endReport(Sink sink) {
        sink.section1_();
        sink.body_();
    }

    protected void reportBody(ReportTimeReporter reporterWithResults, API oldAPI, API newAPI, Sink sink, ResourceBundle messages) {
        sink.paragraph();
        sink.text(this.getDescription(messages, oldAPI, newAPI));
        sink.paragraph_();
        this.reportDifferences(reporterWithResults.reportsBySeverity.get(DifferenceSeverity.BREAKING), sink, messages, "report.revapi.changes.breaking");
        this.reportDifferences(reporterWithResults.reportsBySeverity.get(DifferenceSeverity.POTENTIALLY_BREAKING), sink, messages, "report.revapi.changes.potentiallyBreaking");
        this.reportDifferences(reporterWithResults.reportsBySeverity.get(DifferenceSeverity.NON_BREAKING), sink, messages, "report.revapi.changes.nonBreaking");
    }

    public String getOutputName() {
        return "revapi-report";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.revapi.name");
    }

    public String getDescription(Locale locale) {
        this.ensureAnalyzed(locale);
        if (this.oldAPI == null || this.newAPI == null) {
            this.getLog().debug((CharSequence)"Was unable to determine the old and new artifacts to compare while determining the report description.");
            return null;
        }
        return this.getDescription(this.getBundle(locale), this.oldAPI, this.newAPI);
    }

    private String getDescription(ResourceBundle messages, API oldAPI, API newAPI) {
        String message = messages.getString("report.revapi.description");
        return MessageFormat.format(message, this.niceList(oldAPI.getArchives()), this.niceList(newAPI.getArchives()));
    }

    protected Analyzer prepareAnalyzer(Locale locale) {
        HashMap<String, Object> contextData = null;
        if (this.generateSiteReport) {
            contextData = new HashMap<String, Object>();
            contextData.put("org.revapi.maven.report.minSeverity", this.reportSeverity.asDifferenceSeverity());
        }
        AnalyzerBuilder.Result res = AnalyzerBuilder.forGavs(this.oldArtifacts, this.newArtifacts).withAlwaysCheckForReleasedVersion(this.alwaysCheckForReleaseVersion).withPipelineConfiguration(this.pipelineConfiguration).withAnalysisConfiguration(this.analysisConfiguration).withAnalysisConfigurationFiles(this.analysisConfigurationFiles).withCheckDependencies(this.checkDependencies).withResolveProvidedDependencies(this.resolveProvidedDependencies).withResolveTransitiveProvidedDependencies(this.resolveTransitiveProvidedDependencies).withDisallowedExtensions(this.disallowedExtensions).withFailOnMissingConfigurationFiles(this.failOnMissingConfigurationFiles).withFailOnUnresolvedArtifacts(this.failOnUnresolvedArtifacts).withFailOnUnresolvedDependencies(this.failOnUnresolvedDependencies).withLocale(locale).withLog(this.getLog()).withNewVersion(this.newVersion).withOldVersion(this.oldVersion).withProject(this.project).withReporter(this.generateSiteReport ? ReportTimeReporter.class : null).withRepositorySystem(this.repositorySystem).withRepositorySystemSession(this.repositorySystemSession).withSkip(this.skip).withVersionFormat(this.versionFormat).withContextData(contextData).build();
        if (res.skip) {
            this.skip = true;
        }
        this.oldArtifacts = res.oldArtifacts;
        this.newArtifacts = res.newArtifacts;
        return res.analyzer;
    }

    private void ensureAnalyzed(Locale locale) {
        if (!this.skip && this.analysisResult == null) {
            Analyzer analyzer = this.prepareAnalyzer(locale);
            if (analyzer == null) {
                return;
            }
            try (AnalysisResult res = analyzer.analyze();){
                res.throwIfFailed();
                this.oldAPI = analyzer.getResolvedOldApi();
                this.newAPI = analyzer.getResolvedNewApi();
                this.analysisResult = res;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to generate report.", e);
            }
        }
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("revapi-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected String niceList(Iterable<? extends Archive> archives) {
        StringBuilder bld = new StringBuilder();
        Iterator<? extends Archive> it = archives.iterator();
        if (it.hasNext()) {
            bld.append(it.next().getName());
        } else {
            return "";
        }
        while (it.hasNext()) {
            bld.append(", ").append(it.next().getName());
        }
        return bld.toString();
    }

    private void reportDifferences(EnumMap<CompatibilityType, List<ReportTimeReporter.DifferenceReport>> diffsPerType, Sink sink, ResourceBundle bundle, String typeKey) {
        if (diffsPerType == null || diffsPerType.isEmpty()) {
            return;
        }
        sink.section2();
        sink.sectionTitle2();
        sink.text(bundle.getString(typeKey));
        sink.sectionTitle2_();
        this.reportDifferences(diffsPerType.get(CompatibilityType.BINARY), sink, bundle, "report.revapi.compatibilityType.binary");
        this.reportDifferences(diffsPerType.get(CompatibilityType.SOURCE), sink, bundle, "report.revapi.compatibilityType.source");
        this.reportDifferences(diffsPerType.get(CompatibilityType.SEMANTIC), sink, bundle, "report.revapi.compatibilityType.semantic");
        this.reportDifferences(diffsPerType.get(CompatibilityType.OTHER), sink, bundle, "report.revapi.compatibilityType.other");
        sink.section2_();
    }

    private void reportDifferences(List<ReportTimeReporter.DifferenceReport> diffs, Sink sink, ResourceBundle bundle, String typeKey) {
        if (diffs == null || diffs.isEmpty()) {
            return;
        }
        sink.section3();
        sink.sectionTitle3();
        sink.text(bundle.getString(typeKey));
        sink.sectionTitle3_();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.revapi.difference.code"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.revapi.difference.element"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.revapi.difference.description"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        diffs.sort((d1, d2) -> {
            String c1 = d1.difference.code;
            String c2 = d2.difference.code;
            int cmp = c1.compareTo(c2);
            if (cmp != 0) {
                return cmp;
            }
            Element e1 = d1.newElement == null ? d1.oldElement : d1.newElement;
            Element e2 = d2.newElement == null ? d2.oldElement : d2.newElement;
            cmp = e1.getClass().getName().compareTo(e2.getClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return e1.getFullHumanReadableString().compareTo(e2.getFullHumanReadableString());
        });
        for (ReportTimeReporter.DifferenceReport d : diffs) {
            String element = d.oldElement == null ? d.newElement.getFullHumanReadableString() : d.oldElement.getFullHumanReadableString();
            sink.tableRow();
            sink.tableCell();
            sink.monospaced();
            sink.text(d.difference.code);
            sink.monospaced_();
            sink.tableCell_();
            sink.tableCell();
            sink.monospaced();
            sink.bold();
            sink.text(element);
            sink.bold_();
            sink.monospaced_();
            sink.tableCell();
            sink.text(d.difference.description);
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.section3_();
    }
}

