/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v109.performancetimeline.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v109.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v109.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

public class LargestContentfulPaint {
    private final TimeSinceEpoch renderTime;
    private final TimeSinceEpoch loadTime;
    private final Number size;
    private final Optional<String> elementId;
    private final Optional<String> url;
    private final Optional<BackendNodeId> nodeId;

    public LargestContentfulPaint(TimeSinceEpoch renderTime, TimeSinceEpoch loadTime, Number size, Optional<String> elementId, Optional<String> url, Optional<BackendNodeId> nodeId) {
        this.renderTime = Objects.requireNonNull(renderTime, "renderTime is required");
        this.loadTime = Objects.requireNonNull(loadTime, "loadTime is required");
        this.size = Objects.requireNonNull(size, "size is required");
        this.elementId = elementId;
        this.url = url;
        this.nodeId = nodeId;
    }

    public TimeSinceEpoch getRenderTime() {
        return this.renderTime;
    }

    public TimeSinceEpoch getLoadTime() {
        return this.loadTime;
    }

    public Number getSize() {
        return this.size;
    }

    public Optional<String> getElementId() {
        return this.elementId;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<BackendNodeId> getNodeId() {
        return this.nodeId;
    }

    private static LargestContentfulPaint fromJson(JsonInput input) {
        TimeSinceEpoch renderTime = null;
        TimeSinceEpoch loadTime = null;
        Number size = 0;
        Optional<String> elementId = Optional.empty();
        Optional<String> url = Optional.empty();
        Optional<BackendNodeId> nodeId = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "renderTime": {
                    renderTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block16;
                }
                case "loadTime": {
                    loadTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block16;
                }
                case "size": {
                    size = input.nextNumber();
                    continue block16;
                }
                case "elementId": {
                    elementId = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "nodeId": {
                    nodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LargestContentfulPaint(renderTime, loadTime, size, elementId, url, nodeId);
    }
}

