/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.accessibility;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v118.accessibility.model.AXNode;
import org.openqa.selenium.devtools.v118.accessibility.model.AXNodeId;
import org.openqa.selenium.devtools.v118.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v118.dom.model.NodeId;
import org.openqa.selenium.devtools.v118.page.model.FrameId;
import org.openqa.selenium.devtools.v118.runtime.model.RemoteObjectId;

@Beta
public class Accessibility {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Accessibility.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Accessibility.enable", Map.copyOf(params));
    }

    @Beta
    public static Command<List<AXNode>> getPartialAXTree(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Boolean> fetchRelatives) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        fetchRelatives.ifPresent(p -> params.put("fetchRelatives", p));
        return new Command("Accessibility.getPartialAXTree", Map.copyOf(params), ConverterFunctions.map((String)"nodes", List.class));
    }

    @Beta
    public static Command<List<AXNode>> getFullAXTree(Optional<Integer> depth, Optional<FrameId> frameId) {
        LinkedHashMap params = new LinkedHashMap();
        depth.ifPresent(p -> params.put("depth", p));
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command("Accessibility.getFullAXTree", Map.copyOf(params), ConverterFunctions.map((String)"nodes", List.class));
    }

    @Beta
    public static Command<AXNode> getRootAXNode(Optional<FrameId> frameId) {
        LinkedHashMap params = new LinkedHashMap();
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command("Accessibility.getRootAXNode", Map.copyOf(params), ConverterFunctions.map((String)"node", AXNode.class));
    }

    @Beta
    public static Command<List<AXNode>> getAXNodeAndAncestors(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command("Accessibility.getAXNodeAndAncestors", Map.copyOf(params), ConverterFunctions.map((String)"nodes", List.class));
    }

    @Beta
    public static Command<List<AXNode>> getChildAXNodes(AXNodeId id, Optional<FrameId> frameId) {
        Objects.requireNonNull(id, "id is required");
        LinkedHashMap<String, AXNodeId> params = new LinkedHashMap<String, AXNodeId>();
        params.put("id", id);
        frameId.ifPresent(p -> params.put("frameId", (AXNodeId)p));
        return new Command("Accessibility.getChildAXNodes", Map.copyOf(params), ConverterFunctions.map((String)"nodes", List.class));
    }

    @Beta
    public static Command<List<AXNode>> queryAXTree(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> accessibleName, Optional<String> role) {
        LinkedHashMap params = new LinkedHashMap();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        accessibleName.ifPresent(p -> params.put("accessibleName", p));
        role.ifPresent(p -> params.put("role", p));
        return new Command("Accessibility.queryAXTree", Map.copyOf(params), ConverterFunctions.map((String)"nodes", List.class));
    }

    public static Event<AXNode> loadComplete() {
        return new Event("Accessibility.loadComplete", ConverterFunctions.map((String)"root", AXNode.class));
    }

    public static Event<List<AXNode>> nodesUpdated() {
        return new Event("Accessibility.nodesUpdated", ConverterFunctions.map((String)"nodes", List.class));
    }
}

