/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ProtocolHandshake {
    private static final Logger LOG = Logger.getLogger(ProtocolHandshake.class.getName());

    public Result createSession(HttpClient client, Command command) throws IOException {
        Capabilities desired = (Capabilities)command.getParameters().get("desiredCapabilities");
        desired = desired == null ? new DesiredCapabilities() : desired;
        Capabilities required = (Capabilities)command.getParameters().get("requiredCapabilities");
        required = required == null ? new DesiredCapabilities() : required;
        String des = new BeanToJsonConverter().convert(desired);
        String req = new BeanToJsonConverter().convert(required);
        StringBuilder parameters = new StringBuilder("{");
        this.amendW3CParameters(parameters, des, req);
        parameters.append(",");
        this.amendOssParamters(parameters, des, req);
        parameters.append("}");
        LOG.fine("Attempting bi-dialect session, assuming Postel's Law holds true on the remote end");
        Optional<Result> result = this.createSession(client, parameters);
        if (!result.isPresent()) {
            parameters = new StringBuilder("{");
            this.amendOssParamters(parameters, des, req);
            parameters.append("}");
            LOG.fine("Falling back to original OSS JSON Wire Protocol.");
            result = this.createSession(client, parameters);
        }
        if (!result.isPresent()) {
            parameters = new StringBuilder("{");
            this.amendW3CParameters(parameters, des, req);
            parameters.append("}");
            LOG.fine("Falling back to straight W3C remote end connection");
            result = this.createSession(client, parameters);
        }
        if (result.isPresent()) {
            Result toReturn = result.get();
            LOG.info(String.format("Detected dialect: %s", new Object[]{toReturn.dialect}));
            return toReturn;
        }
        throw new SessionNotCreatedException(String.format("Unable to create new remote session. desired capabilities = %s, required capabilities = %s", desired, required));
    }

    private Optional<Result> createSession(HttpClient client, StringBuilder params) throws IOException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/session");
        String content = params.toString();
        byte[] data = content.getBytes(Charsets.UTF_8);
        request.setHeader("Content-Length", String.valueOf(data.length));
        request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        request.setContent(data);
        HttpResponse response = client.execute(request, true);
        HashMap jsonBlob = null;
        String resultString = response.getContentString();
        try {
            jsonBlob = new JsonToBeanConverter().convert(Map.class, resultString);
        }
        catch (ClassCastException e) {
            LOG.info("Unable to parse response from server: " + resultString);
            return Optional.empty();
        }
        catch (JsonException e) {
            // empty catch block
        }
        if (jsonBlob == null) {
            jsonBlob = new HashMap();
        }
        Object sessionId = jsonBlob.get("sessionId");
        Object value = jsonBlob.get("value");
        Object w3cError = jsonBlob.get("error");
        Object ossStatus = jsonBlob.get("status");
        Map capabilities = null;
        if (value != null && value instanceof Map) {
            capabilities = (Map)value;
        } else if (value != null && value instanceof Capabilities) {
            capabilities = ((Capabilities)capabilities).asMap();
        }
        if (response.getStatus() == 200 && sessionId != null && capabilities != null) {
            Dialect dialect = ossStatus == null ? Dialect.W3C : Dialect.OSS;
            return Optional.of(new Result(dialect, String.valueOf(sessionId), capabilities));
        }
        Response tempResponse = null;
        if ("session not created".equals(w3cError)) {
            tempResponse = new Response(null);
            tempResponse.setStatus(33);
            tempResponse.setValue(jsonBlob);
        } else if (ossStatus instanceof Number && ((Number)ossStatus).intValue() == 33) {
            tempResponse = new Response(null);
            tempResponse.setStatus(33);
            tempResponse.setValue(jsonBlob);
        }
        if (tempResponse != null) {
            new ErrorHandler().throwIfResponseFailed(tempResponse, 0L);
        }
        return Optional.empty();
    }

    private void amendW3CParameters(StringBuilder params, String desired, String required) {
        params.append("\"capabilities\": {");
        params.append("\"desiredCapabilities\": ").append(desired);
        params.append(",");
        params.append("\"requiredCapabilities\": ").append(required);
        params.append("}");
    }

    private void amendOssParamters(StringBuilder params, String desired, String required) {
        params.append("\"desiredCapabilities\": ").append(desired);
        params.append(",");
        params.append("\"requiredCapabilities\": ").append(required);
    }

    public class Result {
        private final Dialect dialect;
        private final Map<String, ?> capabilities;
        private final SessionId sessionId;

        private Result(Dialect dialect, String sessionId, Map<String, ?> capabilities) {
            this.dialect = dialect;
            this.sessionId = new SessionId((String)Preconditions.checkNotNull((Object)sessionId));
            this.capabilities = capabilities;
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public Response createResponse() {
            Response response = new Response(this.sessionId);
            response.setValue(this.capabilities);
            response.setStatus(0);
            return response;
        }

        public String toString() {
            return String.format("%s: %s", new Object[]{this.dialect, this.capabilities});
        }
    }
}

