/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.beust.jcommander.Parameter;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.internal.utils.configuration.converters.CustomConverter;

class GridConfiguration
extends StandaloneConfiguration {
    @Expose
    @Parameter(names={"-cleanUpCycle"}, description="<Integer> in ms : specifies how often the hub will poll running proxies for timed-out (i.e. hung) threads. Must also specify \"timeout\" option")
    public Integer cleanUpCycle;
    @Expose
    @Parameter(names={"-custom"}, description="<String> : comma separated key=value pairs for custom grid extensions. NOT RECOMMENDED -- may be deprecated in a future revision. Example: -custom myParamA=Value1,myParamB=Value2", converter=CustomConverter.class)
    public Map<String, String> custom = new HashMap<String, String>();
    @Expose
    @Parameter(names={"-host"}, description="<String> IP or hostname : usually determined automatically. Most commonly useful in exotic network configurations (e.g. network with VPN)")
    public String host;
    @Expose
    @Parameter(names={"-maxSession"}, description="<Integer> max number of tests that can run at the same time on the node, irrespective of the browser used")
    public Integer maxSession;
    @Expose
    @Parameter(names={"-servlet", "-servlets"}, description="<String> : list of extra servlets the grid (hub or node) will make available. Specify multiple on the command line: -servlet tld.company.ServletA -servlet tld.company.ServletB. The servlet must exist in the path: /grid/admin/ServletA /grid/admin/ServletB")
    public List<String> servlets = new ArrayList<String>();
    @Expose
    @Parameter(names={"-withoutServlet", "-withoutServlets"}, description="<String> : list of default (hub or node) servlets to disable. Advanced use cases only. Not all default servlets can be disabled. Specify multiple on the command line: -withoutServlet tld.company.ServletA -withoutServlet tld.company.ServletB")
    public List<String> withoutServlets = new ArrayList<String>();

    GridConfiguration() {
    }

    public void merge(GridConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(other.cleanUpCycle, this.cleanUpCycle)) {
            this.cleanUpCycle = other.cleanUpCycle;
        }
        if (this.isMergeAble(other.custom, this.custom)) {
            if (this.custom == null) {
                this.custom = new HashMap<String, String>();
            }
            this.custom.putAll(other.custom);
        }
        if (this.isMergeAble(other.maxSession, this.maxSession) && other.maxSession > 0) {
            this.maxSession = other.maxSession;
        }
        if (this.isMergeAble(other.servlets, this.servlets)) {
            this.servlets = other.servlets;
        }
        if (this.isMergeAble(other.withoutServlets, this.withoutServlets)) {
            this.withoutServlets = other.withoutServlets;
        }
    }

    public boolean isWithOutServlet(Class<? extends Servlet> servlet) {
        return this.withoutServlets != null && servlet != null && this.withoutServlets.contains(servlet.getCanonicalName());
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "cleanUpCycle", this.cleanUpCycle));
        sb.append((CharSequence)this.toString(format, "custom", this.custom));
        sb.append((CharSequence)this.toString(format, "host", this.host));
        sb.append((CharSequence)this.toString(format, "maxSession", this.maxSession));
        sb.append((CharSequence)this.toString(format, "servlets", this.servlets));
        sb.append((CharSequence)this.toString(format, "withoutServlets", this.withoutServlets));
        return sb.toString();
    }
}

