/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.fix.NewQuickFix;
import org.sonar.api.batch.sensor.issue.fix.QuickFix;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.batch.sensor.issue.internal.NoOpNewQuickFix;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Preconditions;

public class DefaultIssue
extends AbstractDefaultIssue<DefaultIssue>
implements Issue,
NewIssue {
    private RuleKey ruleKey;
    private Double gap;
    private Severity overriddenSeverity;
    private boolean quickFixAvailable = false;
    private String ruleDescriptionContextKey;

    public DefaultIssue(DefaultInputProject project) {
        this(project, null);
    }

    public DefaultIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(project, storage);
    }

    public DefaultIssue forRule(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    public DefaultIssue gap(@Nullable Double gap) {
        Preconditions.checkArgument((gap == null || gap >= 0.0 ? 1 : 0) != 0, (String)String.format("Gap must be greater than or equal 0 (got %s)", gap));
        this.gap = gap;
        return this;
    }

    public DefaultIssue overrideSeverity(@Nullable Severity severity) {
        this.overriddenSeverity = severity;
        return this;
    }

    public DefaultIssue setQuickFixAvailable(boolean quickFixAvailable) {
        this.quickFixAvailable = quickFixAvailable;
        return this;
    }

    public NewQuickFix newQuickFix() {
        return new NoOpNewQuickFix();
    }

    public NewIssue addQuickFix(NewQuickFix newQuickFix) {
        this.quickFixAvailable = true;
        return this;
    }

    public DefaultIssue setRuleDescriptionContextKey(@Nullable String ruleDescriptionContextKey) {
        this.ruleDescriptionContextKey = ruleDescriptionContextKey;
        return this;
    }

    public boolean isQuickFixAvailable() {
        return this.quickFixAvailable;
    }

    public Optional<String> ruleDescriptionContextKey() {
        return Optional.ofNullable(this.ruleDescriptionContextKey);
    }

    public List<QuickFix> quickFixes() {
        throw new UnsupportedOperationException();
    }

    public Severity overriddenSeverity() {
        return this.overriddenSeverity;
    }

    public Double gap() {
        return this.gap;
    }

    @Override
    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.ruleKey, "ruleKey is mandatory on issue");
        Preconditions.checkState((this.primaryLocation != null ? 1 : 0) != 0, (String)"Primary location is mandatory on every issue");
        this.storage.store((Issue)this);
    }
}

