/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.datascope.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springblade.core.datascope.constant.DataScopeConstant;
import org.springblade.core.datascope.handler.ScopeModelHandler;
import org.springblade.core.datascope.model.DataScopeModel;
import org.springblade.core.tool.utils.CacheUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class BladeScopeModelHandler
implements ScopeModelHandler {
    private static final String SCOPE_CACHE_CODE = "dataScope:code:";
    private static final String SCOPE_CACHE_CLASS = "dataScope:class:";
    private static final String DEPT_CACHE_ANCESTORS = "dept:ancestors:";
    private static final DataScopeModel SEARCHED_DATA_SCOPE_MODEL = new DataScopeModel(Boolean.TRUE);
    private final JdbcTemplate jdbcTemplate;

    @Override
    public DataScopeModel getDataScopeByMapper(String mapperId, String roleId) {
        ArrayList<String> args = new ArrayList<String>(Collections.singletonList(mapperId));
        List roleIds = Func.toLongList((String)roleId);
        args.addAll(roleIds);
        DataScopeModel dataScope = (DataScopeModel)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CLASS, (Object)(mapperId + ":" + roleId), DataScopeModel.class);
        if (dataScope == null || !dataScope.getSearched().booleanValue()) {
            List list = this.jdbcTemplate.query(DataScopeConstant.dataByMapper(roleIds.size()), (RowMapper)new BeanPropertyRowMapper(DataScopeModel.class), args.toArray());
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                dataScope = (DataScopeModel)list.iterator().next();
                dataScope.setSearched(Boolean.TRUE);
            } else {
                dataScope = SEARCHED_DATA_SCOPE_MODEL;
            }
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CLASS, (Object)(mapperId + ":" + roleId), (Object)dataScope);
        }
        return StringUtil.isNotBlank((CharSequence)dataScope.getResourceCode()) ? dataScope : null;
    }

    @Override
    public DataScopeModel getDataScopeByCode(String code) {
        DataScopeModel dataScope = (DataScopeModel)CacheUtil.get((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)code, DataScopeModel.class);
        if (dataScope == null || !dataScope.getSearched().booleanValue()) {
            List list = this.jdbcTemplate.query("select resource_code, scope_column, scope_field, scope_type, scope_value from blade_scope_data where resource_code = ?", (RowMapper)new BeanPropertyRowMapper(DataScopeModel.class), new Object[]{code});
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                dataScope = (DataScopeModel)list.iterator().next();
                dataScope.setSearched(Boolean.TRUE);
            } else {
                dataScope = SEARCHED_DATA_SCOPE_MODEL;
            }
            CacheUtil.put((String)"blade:sys", (String)SCOPE_CACHE_CODE, (Object)code, (Object)dataScope);
        }
        return StringUtil.isNotBlank((CharSequence)dataScope.getResourceCode()) ? dataScope : null;
    }

    @Override
    public List<Long> getDeptAncestors(Long deptId) {
        return (List)CacheUtil.get((String)"blade:sys", (String)DEPT_CACHE_ANCESTORS, (Object)deptId, () -> this.jdbcTemplate.queryForList("select id from blade_dept where ancestors like concat(concat('%', ?),'%') and is_deleted = 0", Long.class, new Object[]{deptId}));
    }

    @Generated
    public BladeScopeModelHandler(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

