/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.loadbalancer.config;

import org.springblade.core.loadbalancer.props.BladeLoadBalancerProperties;
import org.springblade.core.loadbalancer.rule.GrayscaleLoadBalancer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientSpecification;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@AutoConfiguration
@AutoConfigureBefore(value={LoadBalancerClientConfiguration.class})
@EnableConfigurationProperties(value={BladeLoadBalancerProperties.class})
@ConditionalOnProperty(value={"blade.loadbalancer.enabled"}, matchIfMissing=true)
@Order(value=193827465)
public class BladeLoadBalancerConfiguration {
    public static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 193827465;

    @Bean
    public ReactorLoadBalancer<ServiceInstance> reactorServiceInstanceLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, BladeLoadBalancerProperties bladeLoadBalancerProperties) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new GrayscaleLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), bladeLoadBalancerProperties);
    }

    @Bean
    public LoadBalancerClientSpecification loadBalancerClientSpecification() {
        return new LoadBalancerClientSpecification("default.bladeLoadBalancerConfiguration", new Class[]{BladeLoadBalancerConfiguration.class});
    }
}

