/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.config;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import org.springblade.core.oss.AliossTemplate;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={OssConfiguration.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnClass(value={OSSClient.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="alioss")
public class AliossConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OSSClient.class})
    public OSSClient ossClient(OssProperties ossProperties) {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMaxConnections(1024);
        conf.setSocketTimeout(50000);
        conf.setConnectionTimeout(50000);
        conf.setConnectionRequestTimeout(1000);
        conf.setIdleConnectionTime(60000L);
        conf.setMaxErrorRetry(5);
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(ossProperties.getAccessKey(), ossProperties.getSecretKey());
        return new OSSClient(ossProperties.getEndpoint(), (CredentialsProvider)credentialsProvider, conf);
    }

    @Bean
    @ConditionalOnBean(value={OSSClient.class})
    @ConditionalOnMissingBean(value={AliossTemplate.class})
    public AliossTemplate aliossTemplate(OssRule ossRule, OssProperties ossProperties, OSSClient ossClient) {
        return new AliossTemplate(ossClient, ossProperties, ossRule);
    }
}

