/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tenant;

import java.util.function.Supplier;
import lombok.Generated;
import org.springblade.core.secure.utils.AuthUtil;
import org.springframework.core.NamedThreadLocal;
import org.springframework.util.Assert;

public final class TenantUtil {
    private static final ThreadLocal<String> TENANT_ID_HOLDER = new NamedThreadLocal<String>("blade-tenant-id"){

        protected String initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<Boolean> TENANT_IGNORE_HOLDER = new NamedThreadLocal<Boolean>("blade-tenant-ignore"){

        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static String getTenantId() {
        String tenantId = TENANT_ID_HOLDER.get();
        if (tenantId != null) {
            return tenantId;
        }
        return AuthUtil.getTenantId();
    }

    public static <R> R use(String tenantId, Supplier<R> supplier) {
        Assert.hasText((String)tenantId, (String)"\u53c2\u6570 tenantId \u4e3a\u7a7a");
        try {
            TENANT_ID_HOLDER.set(tenantId);
            R r = supplier.get();
            return r;
        }
        finally {
            TENANT_ID_HOLDER.remove();
        }
    }

    public static void use(String tenantId, Runnable runnable) {
        Assert.hasText((String)tenantId, (String)"\u53c2\u6570 tenantId \u4e3a\u7a7a");
        try {
            TENANT_ID_HOLDER.set(tenantId);
            runnable.run();
        }
        finally {
            TENANT_ID_HOLDER.remove();
        }
    }

    public static Boolean isIgnore() {
        return TENANT_IGNORE_HOLDER.get();
    }

    public static <R> R ignore(Supplier<R> supplier) {
        try {
            TENANT_IGNORE_HOLDER.set(Boolean.TRUE);
            R r = supplier.get();
            return r;
        }
        finally {
            TENANT_IGNORE_HOLDER.remove();
        }
    }

    public static void ignore(Runnable runnable) {
        try {
            TENANT_IGNORE_HOLDER.set(Boolean.TRUE);
            runnable.run();
        }
        finally {
            TENANT_IGNORE_HOLDER.remove();
        }
    }

    @Generated
    private TenantUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

