/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.zhipuai.ZhiPuAiChatOptions;
import org.springframework.ai.zhipuai.api.ZhiPuAiApi;
import org.springframework.ai.zhipuai.api.ZhiPuApiConstants;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ZhiPuAiChatModel
implements ChatModel {
    private static final Logger logger = LoggerFactory.getLogger(ZhiPuAiChatModel.class);
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    public final RetryTemplate retryTemplate;
    private final ZhiPuAiChatOptions defaultOptions;
    private final ZhiPuAiApi zhiPuAiApi;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;

    public ZhiPuAiChatModel(ZhiPuAiApi zhiPuAiApi) {
        this(zhiPuAiApi, ZhiPuAiChatOptions.builder().model(ZhiPuAiApi.DEFAULT_CHAT_MODEL).temperature(0.7).build());
    }

    public ZhiPuAiChatModel(ZhiPuAiApi zhiPuAiApi, ZhiPuAiChatOptions options) {
        this(zhiPuAiApi, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public ZhiPuAiChatModel(ZhiPuAiApi zhiPuAiApi, ZhiPuAiChatOptions options, RetryTemplate retryTemplate) {
        this(zhiPuAiApi, options, (ToolCallingManager)ToolCallingManager.builder().build(), retryTemplate, ObservationRegistry.NOOP, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public ZhiPuAiChatModel(ZhiPuAiApi zhiPuAiApi, ZhiPuAiChatOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        this(zhiPuAiApi, options, (ToolCallingManager)ToolCallingManager.builder().build(), retryTemplate, observationRegistry, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public ZhiPuAiChatModel(ZhiPuAiApi zhiPuAiApi, ZhiPuAiChatOptions options, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        this(zhiPuAiApi, options, toolCallingManager, retryTemplate, observationRegistry, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public ZhiPuAiChatModel(ZhiPuAiApi zhiPuAiApi, ZhiPuAiChatOptions options, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)zhiPuAiApi, (String)"ZhiPuAiApi must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        Assert.notNull((Object)toolCallingManager, (String)"toolCallingManager cannot be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"toolExecutionEligibilityPredicate cannot be null");
        this.zhiPuAiApi = zhiPuAiApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
        this.toolCallingManager = toolCallingManager;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
    }

    private static Generation buildGeneration(ZhiPuAiApi.ChatCompletion.Choice choice, Map<String, Object> metadata) {
        List toolCalls = choice.message().toolCalls() == null ? List.of() : choice.message().toolCalls().stream().map(toolCall -> new AssistantMessage.ToolCall(toolCall.id(), "function", toolCall.function().name(), toolCall.function().arguments())).toList();
        AssistantMessage assistantMessage = new AssistantMessage(choice.message().content(), metadata, toolCalls);
        String finishReason = choice.finishReason() != null ? choice.finishReason().name() : "";
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(finishReason).build();
        return new Generation(assistantMessage, generationMetadata);
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        ZhiPuAiApi.ChatCompletionRequest request = this.createRequest(requestPrompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(requestPrompt).provider(ZhiPuApiConstants.PROVIDER_NAME).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.zhiPuAiApi.chatCompletionEntity(request));
            ZhiPuAiApi.ChatCompletion chatCompletion = (ZhiPuAiApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                logger.warn("No chat completion returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            List<ZhiPuAiApi.ChatCompletion.Choice> choices = chatCompletion.choices();
            List<Generation> generations = choices.stream().map(choice -> {
                Map<String, Object> metadata = Map.of("id", chatCompletion.id(), "role", choice.message().role() != null ? choice.message().role().name() : "", "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                return ZhiPuAiChatModel.buildGeneration(choice, metadata);
            }).toList();
            ChatResponse chatResponse = new ChatResponse(generations, this.from((ZhiPuAiApi.ChatCompletion)completionEntity.getBody()));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(requestPrompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(requestPrompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.call(new Prompt(toolExecutionResult.conversationHistory(), requestPrompt.getOptions()));
        }
        return response;
    }

    public ChatOptions getDefaultOptions() {
        return ZhiPuAiChatOptions.fromOptions(this.defaultOptions);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return Flux.deferContextual(contextView -> {
            Prompt requestPrompt = this.buildRequestPrompt(prompt);
            ZhiPuAiApi.ChatCompletionRequest request = this.createRequest(requestPrompt, true);
            Flux completionChunks = (Flux)this.retryTemplate.execute(ctx -> this.zhiPuAiApi.chatCompletionStream(request));
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(requestPrompt).provider(ZhiPuApiConstants.PROVIDER_NAME).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponse = completionChunks.map(this::chunkToChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> {
                try {
                    String id = chatCompletion2.id();
                    List<Generation> generations = chatCompletion2.choices().stream().map(choice -> {
                        if (choice.message().role() != null) {
                            roleMap.putIfAbsent(id, choice.message().role().name());
                        }
                        Map<String, Object> metadata = Map.of("id", chatCompletion2.id(), "role", roleMap.getOrDefault(id, ""), "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                        return ZhiPuAiChatModel.buildGeneration(choice, metadata);
                    }).toList();
                    return new ChatResponse(generations, this.from((ZhiPuAiApi.ChatCompletion)chatCompletion2));
                }
                catch (Exception e) {
                    logger.error("Error processing chat completion", (Throwable)e);
                    return new ChatResponse(List.of());
                }
            }));
            Flux flux = chatResponse.flatMap(response -> {
                if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(requestPrompt.getOptions(), response)) {
                    return Flux.defer(() -> {
                        ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(requestPrompt, response);
                        if (toolExecutionResult.returnDirect()) {
                            return Flux.just((Object)ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                        }
                        return this.stream(new Prompt(toolExecutionResult.conversationHistory(), requestPrompt.getOptions()));
                    }).subscribeOn(Schedulers.boundedElastic());
                }
                return Flux.just((Object)response);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private ChatResponseMetadata from(ZhiPuAiApi.ChatCompletion result) {
        Assert.notNull((Object)result, (String)"ZhiPuAI ChatCompletionResult must not be null");
        return ChatResponseMetadata.builder().id(result.id() != null ? result.id() : "").usage((Usage)(result.usage() != null ? this.getDefaultUsage(result.usage()) : new EmptyUsage())).model(result.model() != null ? result.model() : "").keyValue("created", (Object)(result.created() != null ? result.created() : 0L)).keyValue("system-fingerprint", (Object)(result.systemFingerprint() != null ? result.systemFingerprint() : "")).build();
    }

    private DefaultUsage getDefaultUsage(ZhiPuAiApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    private ZhiPuAiApi.ChatCompletion chunkToChatCompletion(ZhiPuAiApi.ChatCompletionChunk chunk) {
        List<ZhiPuAiApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(cc -> {
            ZhiPuAiApi.ChatCompletionMessage delta = cc.delta();
            if (delta == null) {
                delta = new ZhiPuAiApi.ChatCompletionMessage("", ZhiPuAiApi.ChatCompletionMessage.Role.ASSISTANT);
            }
            return new ZhiPuAiApi.ChatCompletion.Choice(cc.finishReason(), cc.index(), delta, cc.logprobs());
        }).toList();
        return new ZhiPuAiApi.ChatCompletion(chunk.id(), choices, chunk.created(), chunk.model(), chunk.systemFingerprint(), "chat.completion", null);
    }

    private List<ZhiPuAiApi.FunctionTool> getFunctionTools(List<ToolDefinition> toolDefinitions) {
        return toolDefinitions.stream().map(toolDefinition -> {
            ZhiPuAiApi.FunctionTool.Function function = new ZhiPuAiApi.FunctionTool.Function(toolDefinition.description(), toolDefinition.name(), toolDefinition.inputSchema());
            return new ZhiPuAiApi.FunctionTool(function);
        }).toList();
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        ZhiPuAiChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (ZhiPuAiChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, ZhiPuAiChatOptions.class);
            } else {
                runtimeOptions = (ZhiPuAiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, ZhiPuAiChatOptions.class);
            }
        }
        ZhiPuAiChatOptions requestOptions = (ZhiPuAiChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, ZhiPuAiChatOptions.class);
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getInternalToolExecutionEnabled(), (Object)this.defaultOptions.getInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    ZhiPuAiApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        List<ZhiPuAiApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(message -> {
            if (message.getMessageType() == MessageType.USER || message.getMessageType() == MessageType.SYSTEM) {
                UserMessage userMessage;
                Object content = message.getText();
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    ArrayList<ZhiPuAiApi.ChatCompletionMessage.MediaContent> contentList = new ArrayList<ZhiPuAiApi.ChatCompletionMessage.MediaContent>(List.of(new ZhiPuAiApi.ChatCompletionMessage.MediaContent(message.getText())));
                    contentList.addAll(userMessage.getMedia().stream().map(media -> new ZhiPuAiApi.ChatCompletionMessage.MediaContent(new ZhiPuAiApi.ChatCompletionMessage.MediaContent.ImageUrl(this.fromMediaData(media.getMimeType(), media.getData())))).toList());
                    content = contentList;
                }
                return List.of(new ZhiPuAiApi.ChatCompletionMessage(content, ZhiPuAiApi.ChatCompletionMessage.Role.valueOf(message.getMessageType().name())));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<ZhiPuAiApi.ChatCompletionMessage.ToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        ZhiPuAiApi.ChatCompletionMessage.ChatCompletionFunction function = new ZhiPuAiApi.ChatCompletionMessage.ChatCompletionFunction(toolCall.name(), toolCall.arguments());
                        return new ZhiPuAiApi.ChatCompletionMessage.ToolCall(toolCall.id(), toolCall.type(), function);
                    }).toList();
                }
                return List.of(new ZhiPuAiApi.ChatCompletionMessage(assistantMessage.getText(), ZhiPuAiApi.ChatCompletionMessage.Role.ASSISTANT, null, null, toolCalls));
            }
            if (message.getMessageType() == MessageType.TOOL) {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                toolMessage.getResponses().forEach(response -> Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id"));
                return toolMessage.getResponses().stream().map(tr -> new ZhiPuAiApi.ChatCompletionMessage(tr.responseData(), ZhiPuAiApi.ChatCompletionMessage.Role.TOOL, tr.name(), tr.id(), null)).toList();
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getMessageType()));
        }).flatMap(Collection::stream).toList();
        ZhiPuAiApi.ChatCompletionRequest request = new ZhiPuAiApi.ChatCompletionRequest(chatCompletionMessages, stream);
        if (prompt.getOptions() != null) {
            ZhiPuAiChatOptions updatedRuntimeOptions;
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                updatedRuntimeOptions = (ZhiPuAiChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, ZhiPuAiChatOptions.class);
            } else {
                updatedRuntimeOptions = (ZhiPuAiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, ZhiPuAiChatOptions.class);
            }
            request = (ZhiPuAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, ZhiPuAiApi.ChatCompletionRequest.class);
        }
        request = (ZhiPuAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, ZhiPuAiApi.ChatCompletionRequest.class);
        ZhiPuAiChatOptions requestOptions = (ZhiPuAiChatOptions)prompt.getOptions();
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            request = (ZhiPuAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)ZhiPuAiChatOptions.builder().tools(this.getFunctionTools(toolDefinitions)).build(), (Object)request, ZhiPuAiApi.ChatCompletionRequest.class);
        }
        return request;
    }

    private String fromMediaData(MimeType mimeType, Object mediaContentData) {
        if (mediaContentData instanceof byte[]) {
            byte[] bytes = (byte[])mediaContentData;
            return String.format("data:%s;base64,%s", mimeType.toString(), Base64.getEncoder().encodeToString(bytes));
        }
        if (mediaContentData instanceof String) {
            String text = (String)mediaContentData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaContentData.getClass().getSimpleName());
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }
}

