/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.metrics;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.data.metrics.AutoTimer;
import org.springframework.boot.data.metrics.RepositoryTagsProvider;
import org.springframework.boot.data.metrics.TimedAnnotations;
import org.springframework.data.repository.core.support.RepositoryMethodInvocationListener;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

public class MetricsRepositoryMethodInvocationListener
implements RepositoryMethodInvocationListener {
    private final SingletonSupplier<MeterRegistry> registrySupplier;
    private final RepositoryTagsProvider tagsProvider;
    private final String metricName;
    private final AutoTimer autoTimer;

    public MetricsRepositoryMethodInvocationListener(Supplier<MeterRegistry> registrySupplier, RepositoryTagsProvider tagsProvider, String metricName, @Nullable AutoTimer autoTimer) {
        this.registrySupplier = registrySupplier instanceof SingletonSupplier ? (SingletonSupplier)registrySupplier : SingletonSupplier.of(registrySupplier);
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
        this.autoTimer = autoTimer != null ? autoTimer : AutoTimer.DISABLED;
    }

    public void afterInvocation(RepositoryMethodInvocationListener.RepositoryMethodInvocation invocation) {
        Set<Timed> annotations = TimedAnnotations.get(invocation.getMethod(), invocation.getRepositoryInterface());
        Iterable<Tag> tags = this.tagsProvider.repositoryTags(invocation);
        long duration = invocation.getDuration(TimeUnit.NANOSECONDS);
        AutoTimer.apply(this.autoTimer, this.metricName, annotations, builder -> {
            MeterRegistry registry = (MeterRegistry)this.registrySupplier.get();
            Assert.state((registry != null ? 1 : 0) != 0, (String)"'registry' must not be null");
            builder.description("Duration of repository invocations").tags(tags).register(registry).record(duration, TimeUnit.NANOSECONDS);
        });
    }
}

