/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.filter.annotation;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.AotDetector;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.boot.test.context.filter.annotation.TypeExcludeFilters;
import org.springframework.boot.test.context.filter.annotation.TypeExcludeFiltersContextCustomizer;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;

class TypeExcludeFiltersContextCustomizerFactory
implements ContextCustomizerFactory {
    TypeExcludeFiltersContextCustomizerFactory() {
    }

    public @Nullable ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configurationAttributes) {
        if (AotDetector.useGeneratedArtifacts()) {
            return null;
        }
        TestContextAnnotationUtils.AnnotationDescriptor descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(testClass, TypeExcludeFilters.class);
        if (descriptor == null) {
            return null;
        }
        Class<? extends TypeExcludeFilter>[] filterClasses = ((TypeExcludeFilters)descriptor.getAnnotation()).value();
        return this.createContextCustomizer(descriptor.getRootDeclaringClass(), filterClasses);
    }

    private ContextCustomizer createContextCustomizer(Class<?> testClass, Class<?>[] filterClasses) {
        return new TypeExcludeFiltersContextCustomizer(testClass, new LinkedHashSet<Class<? extends TypeExcludeFilter>>(Arrays.asList(filterClasses)));
    }
}

