/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.autoconfigure;

import org.apache.tomcat.websocket.server.WsSci;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWarDeployment;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.thread.Threading;
import org.springframework.boot.tomcat.autoconfigure.TomcatServerProperties;
import org.springframework.boot.tomcat.autoconfigure.TomcatVirtualThreadsWebServerFactoryCustomizer;
import org.springframework.boot.tomcat.autoconfigure.TomcatWebServerFactoryCustomizer;
import org.springframework.boot.tomcat.autoconfigure.WebSocketTomcatWebServerFactoryCustomizer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@ConditionalOnNotWarDeployment
@Configuration(proxyBeanMethods=false)
public class TomcatWebServerConfiguration {
    @Bean
    TomcatWebServerFactoryCustomizer tomcatWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties, TomcatServerProperties tomcatProperties) {
        return new TomcatWebServerFactoryCustomizer(environment, serverProperties, tomcatProperties);
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    TomcatVirtualThreadsWebServerFactoryCustomizer tomcatVirtualThreadsProtocolHandlerCustomizer() {
        return new TomcatVirtualThreadsWebServerFactoryCustomizer();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WsSci.class})
    static class TomcatWebSocketConfiguration {
        TomcatWebSocketConfiguration() {
        }

        @Bean
        WebSocketTomcatWebServerFactoryCustomizer webSocketWebServerCustomizer() {
            return new WebSocketTomcatWebServerFactoryCustomizer();
        }
    }
}

