/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.autoconfigure.reactive;

import org.apache.catalina.startup.Tomcat;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.tomcat.TomcatContextCustomizer;
import org.springframework.boot.tomcat.TomcatProtocolHandlerCustomizer;
import org.springframework.boot.tomcat.autoconfigure.TomcatServerProperties;
import org.springframework.boot.tomcat.autoconfigure.TomcatWebServerConfiguration;
import org.springframework.boot.tomcat.reactive.TomcatReactiveWebServerFactory;
import org.springframework.boot.web.server.autoconfigure.reactive.ReactiveWebServerConfiguration;
import org.springframework.boot.web.server.reactive.ReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.ReactiveHttpInputMessage;

@AutoConfiguration
@ConditionalOnClass(value={ReactiveHttpInputMessage.class, Tomcat.class, TomcatReactiveWebServerFactory.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={TomcatServerProperties.class})
@Import(value={TomcatWebServerConfiguration.class, ReactiveWebServerConfiguration.class})
public class TomcatReactiveWebServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    TomcatReactiveWebServerFactory tomcatReactiveWebServerFactory(ObjectProvider<TomcatConnectorCustomizer> connectorCustomizers, ObjectProvider<TomcatContextCustomizer> contextCustomizers, ObjectProvider<TomcatProtocolHandlerCustomizer<?>> protocolHandlerCustomizers) {
        TomcatReactiveWebServerFactory factory = new TomcatReactiveWebServerFactory();
        factory.getConnectorCustomizers().addAll(connectorCustomizers.orderedStream().toList());
        factory.getContextCustomizers().addAll(contextCustomizers.orderedStream().toList());
        factory.getProtocolHandlerCustomizers().addAll(protocolHandlerCustomizers.orderedStream().toList());
        return factory;
    }
}

