/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server;

import java.security.KeyStore;
import org.springframework.boot.ssl.NoSuchSslBundleException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreDetails;
import org.springframework.boot.ssl.pem.PemSslStoreBundle;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.boot.web.server.Ssl;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class WebServerSslBundle
implements SslBundle {
    private final SslStoreBundle stores;
    private final SslBundleKey key;
    private final SslOptions options;
    private final String protocol;
    private final SslManagerBundle managers;

    private WebServerSslBundle(SslStoreBundle stores, String keyPassword, Ssl ssl) {
        this.stores = stores;
        this.key = SslBundleKey.of((String)keyPassword, (String)ssl.getKeyAlias());
        this.protocol = ssl.getProtocol();
        this.options = SslOptions.of((String[])ssl.getCiphers(), (String[])ssl.getEnabledProtocols());
        this.managers = SslManagerBundle.from((SslStoreBundle)this.stores, (SslBundleKey)this.key);
    }

    private static SslStoreBundle createPemKeyStoreBundle(Ssl ssl) {
        PemSslStoreDetails keyStoreDetails = new PemSslStoreDetails(ssl.getKeyStoreType(), ssl.getCertificate(), ssl.getCertificatePrivateKey()).withAlias(ssl.getKeyAlias());
        return new PemSslStoreBundle(keyStoreDetails, null);
    }

    private static SslStoreBundle createPemTrustStoreBundle(Ssl ssl) {
        PemSslStoreDetails trustStoreDetails = new PemSslStoreDetails(ssl.getTrustStoreType(), ssl.getTrustCertificate(), ssl.getTrustCertificatePrivateKey()).withAlias(ssl.getKeyAlias());
        return new PemSslStoreBundle(null, trustStoreDetails);
    }

    private static SslStoreBundle createJksKeyStoreBundle(Ssl ssl) {
        JksSslStoreDetails keyStoreDetails = new JksSslStoreDetails(ssl.getKeyStoreType(), ssl.getKeyStoreProvider(), ssl.getKeyStore(), ssl.getKeyStorePassword());
        return new JksSslStoreBundle(keyStoreDetails, null);
    }

    private static SslStoreBundle createJksTrustStoreBundle(Ssl ssl) {
        JksSslStoreDetails trustStoreDetails = new JksSslStoreDetails(ssl.getTrustStoreType(), ssl.getTrustStoreProvider(), ssl.getTrustStore(), ssl.getTrustStorePassword());
        return new JksSslStoreBundle(null, trustStoreDetails);
    }

    public SslStoreBundle getStores() {
        return this.stores;
    }

    public SslBundleKey getKey() {
        return this.key;
    }

    public SslOptions getOptions() {
        return this.options;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SslManagerBundle getManagers() {
        return this.managers;
    }

    public static SslBundle get(Ssl ssl) throws NoSuchSslBundleException {
        return WebServerSslBundle.get(ssl, null);
    }

    public static SslBundle get(Ssl ssl, SslBundles sslBundles) throws NoSuchSslBundleException {
        Assert.state((boolean)Ssl.isEnabled(ssl), (String)"SSL is not enabled");
        String keyPassword = ssl.getKeyPassword();
        String bundleName = ssl.getBundle();
        if (StringUtils.hasText((String)bundleName)) {
            Assert.state((sslBundles != null ? 1 : 0) != 0, () -> "SSL bundle '%s' was requested but no SslBundles instance was provided".formatted(bundleName));
            return sslBundles.getBundle(bundleName);
        }
        SslStoreBundle stores = WebServerSslBundle.createStoreBundle(ssl);
        return new WebServerSslBundle(stores, keyPassword, ssl);
    }

    private static SslStoreBundle createStoreBundle(Ssl ssl) {
        KeyStore keyStore = WebServerSslBundle.createKeyStore(ssl);
        KeyStore trustStore = WebServerSslBundle.createTrustStore(ssl);
        return new WebServerSslStoreBundle(keyStore, trustStore, ssl.getKeyStorePassword());
    }

    private static KeyStore createKeyStore(Ssl ssl) {
        if (WebServerSslBundle.hasPemKeyStoreProperties(ssl)) {
            return WebServerSslBundle.createPemKeyStoreBundle(ssl).getKeyStore();
        }
        if (WebServerSslBundle.hasJksKeyStoreProperties(ssl)) {
            return WebServerSslBundle.createJksKeyStoreBundle(ssl).getKeyStore();
        }
        return null;
    }

    private static KeyStore createTrustStore(Ssl ssl) {
        if (WebServerSslBundle.hasPemTrustStoreProperties(ssl)) {
            return WebServerSslBundle.createPemTrustStoreBundle(ssl).getTrustStore();
        }
        if (WebServerSslBundle.hasJksTrustStoreProperties(ssl)) {
            return WebServerSslBundle.createJksTrustStoreBundle(ssl).getTrustStore();
        }
        return null;
    }

    private static boolean hasPemKeyStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && ssl.getCertificate() != null && ssl.getCertificatePrivateKey() != null;
    }

    private static boolean hasPemTrustStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && ssl.getTrustCertificate() != null;
    }

    private static boolean hasJksKeyStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && (ssl.getKeyStore() != null || ssl.getKeyStoreType() != null && ssl.getKeyStoreType().equals("PKCS11"));
    }

    private static boolean hasJksTrustStoreProperties(Ssl ssl) {
        return Ssl.isEnabled(ssl) && (ssl.getTrustStore() != null || ssl.getTrustStoreType() != null && ssl.getTrustStoreType().equals("PKCS11"));
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator((Object)this);
        creator.append("key", (Object)this.key);
        creator.append("protocol", (Object)this.protocol);
        creator.append("stores", (Object)this.stores);
        creator.append("options", (Object)this.options);
        return creator.toString();
    }

    private static final class WebServerSslStoreBundle
    implements SslStoreBundle {
        private final KeyStore keyStore;
        private final KeyStore trustStore;
        private final String keyStorePassword;

        private WebServerSslStoreBundle(KeyStore keyStore, KeyStore trustStore, String keyStorePassword) {
            Assert.state((keyStore != null || trustStore != null ? 1 : 0) != 0, (String)"SSL is enabled but no trust material is configured for the default host");
            this.keyStore = keyStore;
            this.trustStore = trustStore;
            this.keyStorePassword = keyStorePassword;
        }

        public KeyStore getKeyStore() {
            return this.keyStore;
        }

        public KeyStore getTrustStore() {
            return this.trustStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public String toString() {
            ToStringCreator creator = new ToStringCreator((Object)this);
            creator.append("keyStore.type", (Object)(this.keyStore != null ? this.keyStore.getType() : "none"));
            creator.append("keyStorePassword", (Object)(this.keyStorePassword != null ? "******" : null));
            creator.append("trustStore.type", (Object)(this.trustStore != null ? this.trustStore.getType() : "none"));
            return creator.toString();
        }
    }
}

