/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server.metrics;

import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.Executor;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.eureka.server.EurekaServerAutoConfiguration;
import org.springframework.cloud.netflix.eureka.server.metrics.DefaultEurekaInstanceTagsProvider;
import org.springframework.cloud.netflix.eureka.server.metrics.EurekaInstanceMonitor;
import org.springframework.cloud.netflix.eureka.server.metrics.EurekaInstanceTagsProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;

@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnBean(value={MeterRegistry.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, EurekaServerAutoConfiguration.class})
@ConditionalOnProperty(name={"eureka.server.metrics.enabled"}, havingValue="true")
class EurekaInstanceMetricsAutoConfiguration {
    EurekaInstanceMetricsAutoConfiguration() {
    }

    @ConditionalOnMissingBean
    @Bean
    public EurekaInstanceTagsProvider eurekaInstanceTagProvider() {
        return new DefaultEurekaInstanceTagsProvider();
    }

    @ConditionalOnMissingBean
    @Bean
    public EurekaInstanceMonitor eurekaInstanceMeterBinder(MeterRegistry meterRegistry, PeerAwareInstanceRegistry instanceRegistry, EurekaInstanceTagsProvider tagProvider, TaskExecutor executor) {
        return new EurekaInstanceMonitor(meterRegistry, instanceRegistry, tagProvider, (Executor)executor);
    }
}

