/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.aot.generate.DefaultParameterOrigin;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.Assert;

public interface AotRepositoryConstructorBuilder {
    default public void addParameter(String parameterName, Class<?> type) {
        this.addParameter(parameterName, ResolvableType.forClass(type));
    }

    default public void addParameter(String parameterName, ResolvableType type) {
        this.addParameter(parameterName, type, true);
    }

    default public void addParameter(String parameterName, Class<?> type, boolean bindToField) {
        this.addParameter(parameterName, ResolvableType.forClass(type), bindToField);
    }

    default public void addParameter(String parameterName, ResolvableType type, boolean bindToField) {
        this.addParameter(parameterName, type, (ConstructorParameterCustomizer c) -> c.bindToField(bindToField));
    }

    default public void addParameter(String parameterName, Class<?> type, Consumer<ConstructorParameterCustomizer> parameterCustomizer) {
        this.addParameter(parameterName, ResolvableType.forClass(type), parameterCustomizer);
    }

    public void addParameter(String var1, ResolvableType var2, Consumer<ConstructorParameterCustomizer> var3);

    public void customize(ConstructorCustomizer var1);

    public static interface ConstructorParameterCustomizer {
        default public ConstructorParameterCustomizer bindToField() {
            return this.bindToField(true);
        }

        public ConstructorParameterCustomizer bindToField(boolean var1);

        public void origin(BeanReference var1);

        public void origin(Function<FragmentParameterContext, ParameterOrigin> var1);
    }

    public static interface ParameterOrigin {
        public static ParameterOrigin of(String reference, CodeBlock codeBlock) {
            Assert.hasText((String)reference, (String)"Parameter reference must not be empty");
            return new DefaultParameterOrigin(reference, codeBlock);
        }

        public static ParameterOrigin of(CodeBlock codeBlock) {
            Assert.notNull((Object)codeBlock, (String)"CodeBlock reference must not be empty");
            return new DefaultParameterOrigin(null, codeBlock);
        }

        public static ParameterOrigin ofReference(String reference) {
            Assert.hasText((String)reference, (String)"Parameter reference must not be empty");
            return ParameterOrigin.of(reference, CodeBlock.builder().build());
        }

        public @Nullable String getReference();

        public CodeBlock getCodeBlock();
    }

    public static interface FragmentParameterContext {
        public String beanFactory();

        default public ParameterOrigin getBeanFactory() {
            return ParameterOrigin.ofReference(this.beanFactory());
        }

        public String fragmentCreationContext();

        default public ParameterOrigin getFragmentCreationContext() {
            return ParameterOrigin.ofReference(this.fragmentCreationContext());
        }

        public String localVariable(String var1);
    }

    public static interface ConstructorCustomizer {
        public void customize(CodeBlock.Builder var1);
    }
}

