/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.document.MapDocument;
import org.springframework.data.elasticsearch.support.StringObjectMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface Document
extends StringObjectMap<Document> {
    public static Document create() {
        return new MapDocument();
    }

    public static Document from(Map<String, ? extends Object> map) {
        Assert.notNull(map, (String)"Map must not be null");
        if (map instanceof LinkedHashMap) {
            return new MapDocument(map);
        }
        return new MapDocument(new LinkedHashMap<String, Object>(map));
    }

    public static Document parse(String json) {
        Assert.notNull((Object)json, (String)"JSON must not be null");
        return new MapDocument().fromJson(json);
    }

    @Override
    default public Document fromJson(String json) {
        Assert.notNull((Object)json, (String)"JSON must not be null");
        this.clear();
        try {
            this.putAll((Map)MapDocument.OBJECT_MAPPER.readerFor(Map.class).readValue(json));
        }
        catch (IOException e) {
            throw new ConversionException("Cannot parse JSON", e);
        }
        return this;
    }

    default public boolean hasId() {
        return false;
    }

    @Nullable
    default public String getIndex() {
        return null;
    }

    default public void setIndex(@Nullable String index) {
        throw new UnsupportedOperationException();
    }

    default public String getId() {
        throw new UnsupportedOperationException();
    }

    default public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    default public boolean hasVersion() {
        return false;
    }

    default public long getVersion() {
        throw new UnsupportedOperationException();
    }

    default public void setVersion(long version) {
        throw new UnsupportedOperationException();
    }

    default public boolean hasSeqNo() {
        return false;
    }

    default public long getSeqNo() {
        throw new UnsupportedOperationException();
    }

    default public void setSeqNo(long seqNo) {
        throw new UnsupportedOperationException();
    }

    default public boolean hasPrimaryTerm() {
        return false;
    }

    default public long getPrimaryTerm() {
        throw new UnsupportedOperationException();
    }

    default public void setPrimaryTerm(long primaryTerm) {
        throw new UnsupportedOperationException();
    }

    default public <R> R transform(Function<? super Document, ? extends R> transformer) {
        Assert.notNull(transformer, (String)"transformer must not be null");
        return transformer.apply(this);
    }
}

