/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.SslVerifyMode;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import java.util.Optional;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.RedisCredentialsProviderFactory;
import org.springframework.lang.Nullable;

class DefaultLettuceClientConfiguration
implements LettuceClientConfiguration {
    private final boolean useSsl;
    private final SslVerifyMode verifyMode;
    private final boolean startTls;
    private final Optional<ClientResources> clientResources;
    private final Optional<ClientOptions> clientOptions;
    private final Optional<String> clientName;
    private final Optional<ReadFrom> readFrom;
    private final Optional<RedisCredentialsProviderFactory> redisCredentialsProviderFactory;
    private final Duration timeout;
    private final Duration shutdownTimeout;
    private final Duration shutdownQuietPeriod;

    DefaultLettuceClientConfiguration(boolean useSsl, SslVerifyMode verifyMode, boolean startTls, @Nullable ClientResources clientResources, @Nullable ClientOptions clientOptions, @Nullable String clientName, @Nullable ReadFrom readFrom, @Nullable RedisCredentialsProviderFactory redisCredentialsProviderFactory, Duration timeout, Duration shutdownTimeout, Duration shutdownQuietPeriod) {
        this.useSsl = useSsl;
        this.verifyMode = verifyMode;
        this.startTls = startTls;
        this.clientResources = Optional.ofNullable(clientResources);
        this.clientOptions = Optional.ofNullable(clientOptions);
        this.clientName = Optional.ofNullable(clientName);
        this.readFrom = Optional.ofNullable(readFrom);
        this.redisCredentialsProviderFactory = Optional.ofNullable(redisCredentialsProviderFactory);
        this.timeout = timeout;
        this.shutdownTimeout = shutdownTimeout;
        this.shutdownQuietPeriod = shutdownQuietPeriod;
    }

    @Override
    public boolean isUseSsl() {
        return this.useSsl;
    }

    @Override
    public boolean isVerifyPeer() {
        return this.verifyMode != SslVerifyMode.NONE;
    }

    @Override
    public SslVerifyMode getVerifyMode() {
        return this.verifyMode;
    }

    @Override
    public boolean isStartTls() {
        return this.startTls;
    }

    @Override
    public Optional<ClientResources> getClientResources() {
        return this.clientResources;
    }

    @Override
    public Optional<ClientOptions> getClientOptions() {
        return this.clientOptions;
    }

    @Override
    public Optional<String> getClientName() {
        return this.clientName;
    }

    @Override
    public Optional<ReadFrom> getReadFrom() {
        return this.readFrom;
    }

    @Override
    public Optional<RedisCredentialsProviderFactory> getRedisCredentialsProviderFactory() {
        return this.redisCredentialsProviderFactory;
    }

    @Override
    public Duration getCommandTimeout() {
        return this.timeout;
    }

    @Override
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @Override
    public Duration getShutdownQuietPeriod() {
        return this.shutdownQuietPeriod;
    }
}

