/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

class JedisClusterHashCommands
implements RedisHashCommands {
    private final JedisClusterConnection connection;

    JedisClusterHashCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().hset(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().hsetnx(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        try {
            return this.connection.getCluster().hget(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            return this.connection.getCluster().hmget(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(hashes, (String)"Hashes must not be null");
        try {
            this.connection.getCluster().hmset(key, hashes);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        try {
            return this.connection.getCluster().hincrBy(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        try {
            return this.connection.getCluster().hincrByFloat(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte @Nullable [] hRandField(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().hrandfield(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public @Nullable Map.Entry<byte[], byte[]> hRandFieldWithValues(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            List mapEntryList = this.connection.getCluster().hrandfieldWithValues(key, 1L);
            return mapEntryList.isEmpty() ? null : (Map.Entry)mapEntryList.get(0);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public @Nullable List<byte[]> hRandField(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().hrandfield(key, count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public @Nullable List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte[] key, long count) {
        try {
            return this.connection.getCluster().hrandfieldWithValues(key, count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        try {
            return this.connection.getCluster().hexists(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            return this.connection.getCluster().hdel(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().hlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().hkeys(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return new ArrayList<byte[]>(this.connection.getCluster().hvals(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().hgetAll(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(final byte[] key, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new ScanCursor<Map.Entry<byte[], byte[]>>(this, options){
            final /* synthetic */ JedisClusterHashCommands this$0;
            {
                this.this$0 = this$0;
                super(options);
            }

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(Cursor.CursorId cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = this.this$0.connection.getCluster().hscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Cursor.CursorId.of(result.getCursor()), result.getResult());
            }
        }.open();
    }

    @Override
    public List<Long> hExpire(byte[] key, long seconds, ExpirationOptions.Condition condition, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            if (condition == ExpirationOptions.Condition.ALWAYS) {
                return this.connection.getCluster().hexpire(key, seconds, fields);
            }
            return this.connection.getCluster().hexpire(key, seconds, ExpiryOption.valueOf((String)condition.name()), fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> hpExpire(byte[] key, long millis, ExpirationOptions.Condition condition, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            if (condition == ExpirationOptions.Condition.ALWAYS) {
                return this.connection.getCluster().hpexpire(key, millis, fields);
            }
            return this.connection.getCluster().hpexpire(key, millis, ExpiryOption.valueOf((String)condition.name()), fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> hExpireAt(byte[] key, long unixTime, ExpirationOptions.Condition condition, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            if (condition == ExpirationOptions.Condition.ALWAYS) {
                return this.connection.getCluster().hexpireAt(key, unixTime, fields);
            }
            return this.connection.getCluster().hexpireAt(key, unixTime, ExpiryOption.valueOf((String)condition.name()), fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> hpExpireAt(byte[] key, long unixTimeInMillis, ExpirationOptions.Condition condition, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            if (condition == ExpirationOptions.Condition.ALWAYS) {
                return this.connection.getCluster().hpexpireAt(key, unixTimeInMillis, fields);
            }
            return this.connection.getCluster().hpexpireAt(key, unixTimeInMillis, ExpiryOption.valueOf((String)condition.name()), fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> hPersist(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            return this.connection.getCluster().hpersist(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> hTtl(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            return this.connection.getCluster().httl(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> hTtl(byte[] key, TimeUnit timeUnit, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            return this.connection.getCluster().httl(key, fields).stream().map(it -> it != null ? Long.valueOf(timeUnit.convert((long)it, TimeUnit.SECONDS)) : null).toList();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Long> hpTtl(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        try {
            return this.connection.getCluster().hpttl(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public @Nullable Long hStrLen(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.getCluster().hstrlen(key, field);
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

