/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisServerAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;

@NullUnmarked
class LettuceServerCommands
implements RedisServerCommands {
    private final LettuceConnection connection;

    LettuceServerCommands(@NonNull LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public void bgReWriteAof() {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::bgrewriteaof);
    }

    @Override
    public void bgSave() {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::bgsave);
    }

    @Override
    public Long lastSave() {
        return (Long)this.connection.invoke().from(RedisServerAsyncCommands::lastsave).get(LettuceConverters::toLong);
    }

    @Override
    public void save() {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::save);
    }

    @Override
    public Long dbSize() {
        return (Long)this.connection.invoke().just(RedisServerAsyncCommands::dbsize);
    }

    @Override
    public void flushDb() {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::flushdb);
    }

    @Override
    public void flushDb(@NonNull RedisServerCommands.FlushOption option) {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::flushdb, LettuceConverters.toFlushMode(option));
    }

    @Override
    public void flushAll() {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::flushall);
    }

    @Override
    public void flushAll(@NonNull RedisServerCommands.FlushOption option) {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::flushall, LettuceConverters.toFlushMode(option));
    }

    @Override
    public Properties info() {
        return this.connection.invoke().from(RedisServerAsyncCommands::info).get(LettuceConverters.stringToProps());
    }

    @Override
    public Properties info(@NonNull String section) {
        Assert.hasText((String)section, (String)"Section must not be null or empty");
        return this.connection.invoke().from(RedisServerAsyncCommands::info, section).get(LettuceConverters.stringToProps());
    }

    @Override
    public void shutdown() {
        this.connection.invokeStatus().just(it -> {
            it.shutdown(true);
            return new CompletedRedisFuture<Object>(null);
        });
    }

    @Override
    public void shutdown(@Nullable RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        boolean save = RedisServerCommands.ShutdownOption.SAVE.equals((Object)option);
        this.connection.invokeStatus().just(it -> {
            it.shutdown(save);
            return new CompletedRedisFuture<Object>(null);
        });
    }

    @Override
    public Properties getConfig(@NonNull String pattern) {
        Assert.hasText((String)pattern, (String)"Pattern must not be null or empty");
        return this.connection.invoke().from(RedisServerAsyncCommands::configGet, pattern).get(LettuceConverters.mapToPropertiesConverter());
    }

    @Override
    public void setConfig(@NonNull String param, @NonNull String value) {
        Assert.hasText((String)param, (String)"Parameter must not be null or empty");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.connection.invokeStatus().just(RedisServerAsyncCommands::configSet, param, value);
    }

    @Override
    public void resetConfigStats() {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::configResetstat);
    }

    @Override
    public void rewriteConfig() {
        this.connection.invokeStatus().just(RedisServerAsyncCommands::configRewrite);
    }

    @Override
    public Long time(@NonNull TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
        return this.connection.invoke().from(RedisServerAsyncCommands::time).get(LettuceConverters.toTimeConverter(timeUnit));
    }

    @Override
    public void killClient(@NonNull String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'");
        String client = "%s:%d".formatted(host, port);
        this.connection.invoke().just(RedisServerAsyncCommands::clientKill, client);
    }

    @Override
    public void setClientName(byte @NonNull [] name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.connection.invoke().just(RedisServerAsyncCommands::clientSetname, name);
    }

    @Override
    public String getClientName() {
        return (String)this.connection.invoke().from(RedisServerAsyncCommands::clientGetname).get(LettuceConverters::toString);
    }

    @Override
    public List<@NonNull RedisClientInfo> getClientList() {
        return this.connection.invoke().from(RedisServerAsyncCommands::clientList).get(LettuceConverters.stringToRedisClientListConverter());
    }

    @Override
    public void replicaOf(@NonNull String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be null for 'REPLICAOF' command");
        this.connection.invoke().just(RedisServerAsyncCommands::slaveof, host, port);
    }

    @Override
    public void replicaOfNoOne() {
        this.connection.invoke().just(RedisServerAsyncCommands::slaveofNoOne);
    }

    @Override
    public void migrate(byte @NonNull [] key, @NonNull RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte @NonNull [] key, @NonNull RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option, long timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)target, (String)"Target node must not be null");
        this.connection.invoke().just(RedisKeyAsyncCommands::migrate, target.getRequiredHost(), target.getRequiredPort(), key, dbIndex, timeout);
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    static class CompletedRedisFuture<T>
    extends CompletableFuture<T>
    implements RedisFuture<T> {
        public CompletedRedisFuture(T value) {
            this.complete(value);
        }

        public String getError() {
            return "";
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return LettuceFutures.awaitAll((long)timeout, (TimeUnit)unit, (Future[])new Future[]{this});
        }
    }
}

