/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.DefaultTuple;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveZSetOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@NullUnmarked
class DefaultReactiveZSetOperations<K, V>
implements ReactiveZSetOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    public DefaultReactiveZSetOperations(@NonNull ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Mono<Boolean> add(@NonNull K key, @NonNull V value, double score) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zAdd(this.rawKey(key), score, this.rawValue(value)).map(l -> l != 0L));
    }

    @Override
    public Mono<Long> addAll(@NonNull K key, @NonNull Collection<? extends ZSetOperations.TypedTuple<V>> tuples) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(tuples, (String)"Key must not be null");
        return this.createMono(zSetCommands -> Flux.fromIterable((Iterable)tuples).map(t -> new DefaultTuple(ByteUtils.getBytes(this.rawValue(t.getValue())), t.getScore())).collectList().flatMap(serialized -> zSetCommands.zAdd(this.rawKey(key), (Collection<? extends Tuple>)serialized)));
    }

    @Override
    public Mono<Long> remove(@NonNull K key, Object ... values) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        if (values.length == 1) {
            return this.createMono(zSetCommands -> zSetCommands.zRem(this.rawKey(key), this.rawValue(values[0])));
        }
        return this.createMono(zSetCommands -> Flux.fromArray((Object[])values).map(this::rawValue).collectList().flatMap(serialized -> zSetCommands.zRem(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Double> incrementScore(@NonNull K key, @NonNull V value, double delta) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zIncrBy(this.rawKey(key), delta, this.rawValue(value)));
    }

    @Override
    public Mono<V> randomMember(@NonNull K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRandMember(this.rawKey(key))).map(this::readRequiredValue);
    }

    @Override
    public Flux<V> distinctRandomMembers(@NonNull K key, long count) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Negative count not supported; Use randomMembers to allow duplicate elements");
        return this.createFlux(zSetCommands -> zSetCommands.zRandMember(this.rawKey(key), count)).map(this::readRequiredValue);
    }

    @Override
    public Flux<V> randomMembers(@NonNull K key, long count) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Use a positive number for count; This method is already allowing duplicate elements");
        return this.createFlux(zSetCommands -> zSetCommands.zRandMember(this.rawKey(key), -count)).map(this::readRequiredValue);
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> randomMemberWithScore(@NonNull K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRandMemberWithScore(this.rawKey(key))).map(this::readTypedTuple);
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> distinctRandomMembersWithScore(@NonNull K key, long count) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Negative count not supported; Use randomMembers to allow duplicate elements");
        return this.createFlux(zSetCommands -> zSetCommands.zRandMemberWithScore(this.rawKey(key), count)).map(this::readTypedTuple);
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> randomMembersWithScore(@NonNull K key, long count) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Use a positive number for count; This method is already allowing duplicate elements");
        return this.createFlux(zSetCommands -> zSetCommands.zRandMemberWithScore(this.rawKey(key), -count)).map(this::readTypedTuple);
    }

    @Override
    public Mono<Long> rank(@NonNull K key, @NonNull Object o) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRank(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Mono<Long> reverseRank(@NonNull K key, @NonNull Object o) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRevRank(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Flux<V> range(@NonNull K key, @NonNull Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRange(this.rawKey(key), range).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> rangeWithScores(@NonNull K key, @NonNull Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRangeWithScores(this.rawKey(key), range).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> rangeByScore(@NonNull K key, @NonNull Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRangeByScore(this.rawKey(key), range).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(@NonNull K key, @NonNull Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRangeByScoreWithScores(this.rawKey(key), range).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> rangeByScore(@NonNull K key, @NonNull Range<Double> range, @NonNull Limit limit) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRangeByScore(this.rawKey(key), range, limit).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(@NonNull K key, @NonNull Range<Double> range, @NonNull Limit limit) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRangeByScoreWithScores(this.rawKey(key), range, limit).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> reverseRange(@NonNull K key, @NonNull Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRevRange(this.rawKey(key), range).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(@NonNull K key, @NonNull Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRevRangeWithScores(this.rawKey(key), range).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> reverseRangeByScore(@NonNull K key, @NonNull Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRevRangeByScore(this.rawKey(key), range).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(@NonNull K key, @NonNull Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRevRangeByScoreWithScores(this.rawKey(key), range).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> reverseRangeByScore(@NonNull K key, @NonNull Range<Double> range, @NonNull Limit limit) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRevRangeByScore(this.rawKey(key), range, limit).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(@NonNull K key, @NonNull Range<Double> range, @NonNull Limit limit) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRevRangeByScoreWithScores(this.rawKey(key), range, limit).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> rangeAndStoreByLex(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<String> range, @NonNull Limit limit) {
        Assert.notNull(srcKey, (String)"Source key must not be null");
        Assert.notNull(dstKey, (String)"Destination key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRangeStoreByLex(this.rawKey(srcKey), this.rawKey(dstKey), range, limit));
    }

    @Override
    public Mono<Long> reverseRangeAndStoreByLex(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<String> range, @NonNull Limit limit) {
        Assert.notNull(srcKey, (String)"Source key must not be null");
        Assert.notNull(dstKey, (String)"Destination key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRangeStoreRevByLex(this.rawKey(srcKey), this.rawKey(dstKey), range, limit));
    }

    @Override
    public Mono<Long> rangeAndStoreByScore(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<Double> range, @NonNull Limit limit) {
        Assert.notNull(srcKey, (String)"Source key must not be null");
        Assert.notNull(dstKey, (String)"Destination key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRangeStoreByScore(this.rawKey(srcKey), this.rawKey(dstKey), range, limit));
    }

    @Override
    public Mono<Long> reverseRangeAndStoreByScore(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<Double> range, @NonNull Limit limit) {
        Assert.notNull(srcKey, (String)"Source key must not be null");
        Assert.notNull(dstKey, (String)"Destination key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRangeStoreRevByScore(this.rawKey(srcKey), this.rawKey(dstKey), range, limit));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> scan(@NonNull K key, @Nullable ScanOptions options) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)options, (String)"ScanOptions must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zScan(this.rawKey(key), options).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> count(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zCount(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> lexCount(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zLexCount(this.rawKey(key), range));
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> popMin(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zPopMin(this.rawKey(key)).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> popMin(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zPopMin(this.rawKey(key), count).map(this::readTypedTuple));
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> popMin(K key, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        return this.createMono(zSetCommands -> zSetCommands.bZPopMin(this.rawKey(key), timeout).map(this::readTypedTuple));
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> popMax(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zPopMax(this.rawKey(key)).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> popMax(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zPopMax(this.rawKey(key), count).map(this::readTypedTuple));
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> popMax(K key, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        return this.createMono(zSetCommands -> zSetCommands.bZPopMax(this.rawKey(key), timeout).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zCard(this.rawKey(key)));
    }

    @Override
    public Mono<Double> score(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zScore(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Mono<List<Double>> score(K key, Object ... o) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.createMono(zSetCommands -> Flux.fromArray((Object[])o).map(this::rawValue).collectList().flatMap(values -> zSetCommands.zMScore(this.rawKey(key), (Collection<ByteBuffer>)values)));
    }

    @Override
    public Mono<Long> removeRange(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRemRangeByRank(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> removeRangeByLex(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRemRangeByLex(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> removeRangeByScore(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createMono(zSetCommands -> zSetCommands.zRemRangeByScore(this.rawKey(key), range));
    }

    @Override
    public Flux<V> difference(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        return this.createFlux(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(zSetCommands::zDiff).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> differenceWithScores(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        return this.createFlux(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(zSetCommands::zDiffWithScores).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> differenceAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        Assert.notNull(destKey, (String)"Destination key must not be null");
        return this.createMono(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> zSetCommands.zDiffStore(this.rawKey(destKey), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Flux<V> intersect(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        return this.createFlux(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(zSetCommands::zInter).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        return this.createFlux(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(zSetCommands::zInterWithScores).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(K key, Collection<K> otherKeys, Aggregate aggregate, Weights weights) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        Assert.notNull((Object)((Object)aggregate), (String)"Aggregate must not be null");
        Assert.notNull((Object)weights, (String)"Weights must not be null");
        return this.createFlux(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(sets -> zSetCommands.zInterWithScores((List<ByteBuffer>)sets, weights, aggregate)).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        Assert.notNull(destKey, (String)"Destination key must not be null");
        return this.createMono(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> zSetCommands.zInterStore(this.rawKey(destKey), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey, Aggregate aggregate, Weights weights) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        Assert.notNull(destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)((Object)aggregate), (String)"Aggregate must not be null");
        Assert.notNull((Object)weights, (String)"Weights must not be null");
        return this.createMono(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> zSetCommands.zInterStore(this.rawKey(destKey), (List<ByteBuffer>)serialized, weights, aggregate)));
    }

    @Override
    public Flux<V> union(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        return this.createFlux(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(zSetCommands::zUnion).map(this::readRequiredValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        return this.createFlux(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(zSetCommands::zUnionWithScores).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(K key, Collection<K> otherKeys, Aggregate aggregate, Weights weights) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        Assert.notNull((Object)((Object)aggregate), (String)"Aggregate must not be null");
        Assert.notNull((Object)weights, (String)"Weights must not be null");
        return this.createFlux(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(sets -> zSetCommands.zUnionWithScores((List<ByteBuffer>)sets, weights, aggregate)).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> unionAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKey, (String)"Other key must not be null");
        Assert.notNull(destKey, (String)"Destination key must not be null");
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        Assert.notNull(destKey, (String)"Destination key must not be null");
        return this.createMono(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> zSetCommands.zUnionStore(this.rawKey(destKey), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey, Aggregate aggregate, Weights weights) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(otherKeys, (String)"Other keys must not be null");
        Assert.notNull(destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)((Object)aggregate), (String)"Aggregate must not be null");
        Assert.notNull((Object)weights, (String)"Weights must not be null");
        return this.createMono(zSetCommands -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> zSetCommands.zUnionStore(this.rawKey(destKey), (List<ByteBuffer>)serialized, weights, aggregate)));
    }

    @Override
    public Flux<V> rangeByLex(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRangeByLex(this.rawKey(key), range).map(this::readRequiredValue));
    }

    @Override
    public Flux<V> rangeByLex(K key, Range<String> range, Limit limit) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRangeByLex(this.rawKey(key), range, limit).map(this::readRequiredValue));
    }

    @Override
    public Flux<V> reverseRangeByLex(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRevRangeByLex(this.rawKey(key), range).map(this::readRequiredValue));
    }

    @Override
    public Flux<V> reverseRangeByLex(K key, Range<String> range, Limit limit) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        return this.createFlux(zSetCommands -> zSetCommands.zRevRangeByLex(this.rawKey(key), range, limit).map(this::readRequiredValue));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveZSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.zSetCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveZSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null");
        return this.template.doCreateFlux(connection -> (Publisher)function.apply(connection.zSetCommands()));
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private List<K> getKeys(K key, Collection<K> otherKeys) {
        ArrayList<K> keys = new ArrayList<K>(1 + otherKeys.size());
        keys.add(key);
        keys.addAll(otherKeys);
        return keys;
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private @Nullable V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }

    private V readRequiredValue(ByteBuffer buffer) {
        V value = this.readValue(buffer);
        if (value == null) {
            throw new InvalidDataAccessApiUsageException("Deserialized sorted set value is null");
        }
        return value;
    }

    private ZSetOperations.TypedTuple<V> readTypedTuple(Tuple raw) {
        return new DefaultTypedTuple<V>(this.readValue(ByteBuffer.wrap(raw.getValue())), raw.getScore());
    }
}

