/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.HashMapperProvider;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.hash.ObjectHashMapper;
import org.springframework.util.Assert;

class StreamObjectMapper {
    private static final RedisCustomConversions customConversions = new RedisCustomConversions();
    private static final ConversionService conversionService;
    private final HashMapper<Object, Object, Object> mapper;
    private final @Nullable HashMapper<Object, Object, Object> objectHashMapper;

    StreamObjectMapper(HashMapper<?, ?, ?> mapper) {
        Assert.notNull(mapper, (String)"HashMapper must not be null");
        this.mapper = mapper;
        if (mapper instanceof ObjectHashMapper) {
            final ObjectHashMapper ohm = (ObjectHashMapper)mapper;
            this.objectHashMapper = new HashMapper<Object, Object, Object>(this){
                final /* synthetic */ StreamObjectMapper this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Map<Object, Object> toHash(Object object) {
                    return ohm.toHash(object);
                }

                @Override
                public Object fromHash(Map<Object, Object> hash) {
                    Map<byte[], byte[]> map = hash.entrySet().stream().collect(Collectors.toMap(keyMapper -> (byte[])conversionService.convert(keyMapper.getKey(), byte[].class), valueMapper -> (byte[])conversionService.convert(valueMapper.getValue(), byte[].class)));
                    return ohm.fromHash(map);
                }
            };
        } else {
            this.objectHashMapper = null;
        }
    }

    static <K, V, HK, HV> MapRecord<K, HK, HV> toMapRecord(HashMapperProvider<HK, HV> provider, Record<K, V> source) {
        if (source instanceof ObjectRecord) {
            ObjectRecord entry = (ObjectRecord)source;
            if (entry.getValue() instanceof Map) {
                return StreamRecords.newRecord().in(source.getRequiredStream()).withId(source.getId()).ofMap((Map)entry.getValue());
            }
            return entry.toMapRecord(provider.getHashMapper(entry.getValue().getClass()));
        }
        if (source instanceof MapRecord) {
            return (MapRecord)source;
        }
        return Record.of(provider.getHashMapper(source.getClass()).toHash(source)).withStreamKey(source.getRequiredStream());
    }

    static <K, V, HK, HV> ObjectRecord<K, V> toObjectRecord(MapRecord<K, HK, HV> source, HashMapperProvider<HK, HV> provider, Class<V> targetType) {
        return source.toObjectRecord(provider.getHashMapper(targetType));
    }

    static <K, V, HK, HV> @Nullable List<ObjectRecord<K, V>> toObjectRecords(@Nullable List<MapRecord<K, HK, HV>> records, HashMapperProvider<HK, HV> hashMapperProvider, Class<V> targetType) {
        if (records == null) {
            return null;
        }
        if (records.isEmpty()) {
            return Collections.emptyList();
        }
        if (records.size() == 1) {
            return Collections.singletonList(StreamObjectMapper.toObjectRecord(records.get(0), hashMapperProvider, targetType));
        }
        ArrayList<ObjectRecord<K, V>> transformed = new ArrayList<ObjectRecord<K, V>>(records.size());
        HashMapper<V, HK, HV> hashMapper = hashMapperProvider.getHashMapper(targetType);
        for (MapRecord<HK, HK, HV> mapRecord : records) {
            transformed.add(mapRecord.toObjectRecord(hashMapper));
        }
        return transformed;
    }

    final <V, HK, HV> HashMapper<V, HK, HV> getHashMapper(Class<V> targetType) {
        return this.doGetHashMapper(conversionService, targetType);
    }

    protected HashMapper<?, ?, ?> doGetHashMapper(ConversionService conversionService, Class<?> targetType) {
        return this.objectHashMapper != null ? this.objectHashMapper : this.mapper;
    }

    boolean isSimpleType(Class<?> targetType) {
        return customConversions.isSimpleType(targetType);
    }

    ConversionService getConversionService() {
        return conversionService;
    }

    static {
        DefaultConversionService defaultConversionService = new DefaultConversionService();
        customConversions.registerConvertersIn((ConverterRegistry)defaultConversionService);
        conversionService = defaultConversionService;
    }
}

