/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.Assert;

@NullUnmarked
public interface ZSetOperations<K, V> {
    public Boolean add(@NonNull K var1, @NonNull V var2, double var3);

    public Boolean addIfAbsent(@NonNull K var1, @NonNull V var2, double var3);

    public Long add(@NonNull K var1, @NonNull Set<@NonNull TypedTuple<V>> var2);

    public Long addIfAbsent(@NonNull K var1, @NonNull Set<@NonNull TypedTuple<V>> var2);

    public Long remove(@NonNull K var1, Object ... var2);

    public Double incrementScore(@NonNull K var1, @NonNull V var2, double var3);

    public V randomMember(@NonNull K var1);

    public Set<V> distinctRandomMembers(@NonNull K var1, long var2);

    public List<V> randomMembers(@NonNull K var1, long var2);

    public TypedTuple<V> randomMemberWithScore(@NonNull K var1);

    public Set<@NonNull TypedTuple<V>> distinctRandomMembersWithScore(@NonNull K var1, long var2);

    public List<TypedTuple<V>> randomMembersWithScore(@NonNull K var1, long var2);

    public Long rank(@NonNull K var1, @NonNull Object var2);

    public Long reverseRank(@NonNull K var1, @NonNull Object var2);

    public Set<V> range(@NonNull K var1, long var2, long var4);

    public Set<@NonNull TypedTuple<V>> rangeWithScores(@NonNull K var1, long var2, long var4);

    public Set<V> rangeByScore(@NonNull K var1, double var2, double var4);

    public Set<@NonNull TypedTuple<V>> rangeByScoreWithScores(@NonNull K var1, double var2, double var4);

    public Set<V> rangeByScore(@NonNull K var1, double var2, double var4, long var6, long var8);

    public Set<@NonNull TypedTuple<V>> rangeByScoreWithScores(@NonNull K var1, double var2, double var4, long var6, long var8);

    public Set<V> reverseRange(@NonNull K var1, long var2, long var4);

    public Set<@NonNull TypedTuple<V>> reverseRangeWithScores(@NonNull K var1, long var2, long var4);

    public Set<V> reverseRangeByScore(@NonNull K var1, double var2, double var4);

    public Set<@NonNull TypedTuple<V>> reverseRangeByScoreWithScores(@NonNull K var1, double var2, double var4);

    public Set<V> reverseRangeByScore(@NonNull K var1, double var2, double var4, long var6, long var8);

    public Set<@NonNull TypedTuple<V>> reverseRangeByScoreWithScores(@NonNull K var1, double var2, double var4, long var6, long var8);

    public Long count(@NonNull K var1, double var2, double var4);

    public Long lexCount(@NonNull K var1, @NonNull Range<String> var2);

    public TypedTuple<V> popMin(@NonNull K var1);

    public Set<@NonNull TypedTuple<V>> popMin(@NonNull K var1, long var2);

    public TypedTuple<V> popMin(@NonNull K var1, long var2, @NonNull TimeUnit var4);

    default public TypedTuple<@NonNull V> popMin(@NonNull K key, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.popMin(key, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public TypedTuple<V> popMax(@NonNull K var1);

    public Set<TypedTuple<V>> popMax(@NonNull K var1, long var2);

    public TypedTuple<V> popMax(@NonNull K var1, long var2, @NonNull TimeUnit var4);

    default public TypedTuple<V> popMax(@NonNull K key, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.popMax(key, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public Long size(@NonNull K var1);

    public Long zCard(@NonNull K var1);

    public Double score(@NonNull K var1, Object var2);

    public List<Double> score(@NonNull K var1, Object ... var2);

    public Long removeRange(@NonNull K var1, long var2, long var4);

    public Long removeRangeByLex(@NonNull K var1, @NonNull Range<String> var2);

    public Long removeRangeByScore(@NonNull K var1, double var2, double var4);

    default public Set<V> difference(@NonNull K key, @NonNull K otherKey) {
        return this.difference(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Set<V> difference(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Set<@NonNull TypedTuple<V>> differenceWithScores(@NonNull K key, @NonNull K otherKey) {
        return this.differenceWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Set<@NonNull TypedTuple<V>> differenceWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    public Long differenceAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3);

    default public Set<V> intersect(@NonNull K key, @NonNull K otherKey) {
        return this.intersect(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Set<V> intersect(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Set<@NonNull TypedTuple<V>> intersectWithScores(@NonNull K key, @NonNull K otherKey) {
        return this.intersectWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Set<@NonNull TypedTuple<V>> intersectWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Set<TypedTuple<V>> intersectWithScores(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull Aggregate aggregate) {
        return this.intersectWithScores(key, otherKeys, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Set<@NonNull TypedTuple<V>> intersectWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull Aggregate var3, @NonNull Weights var4);

    public Long intersectAndStore(@NonNull K var1, @NonNull K var2, @NonNull K var3);

    public Long intersectAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3);

    default public Long intersectAndStore(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull K destKey, @NonNull Aggregate aggregate) {
        return this.intersectAndStore(key, otherKeys, destKey, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Long intersectAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3, @NonNull Aggregate var4, @NonNull Weights var5);

    default public Set<V> union(@NonNull K key, @NonNull K otherKey) {
        return this.union(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Set<V> union(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Set<@NonNull TypedTuple<V>> unionWithScores(@NonNull K key, @NonNull K otherKey) {
        return this.unionWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Set<@NonNull TypedTuple<V>> unionWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Set<@NonNull TypedTuple<V>> unionWithScores(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull Aggregate aggregate) {
        return this.unionWithScores(key, otherKeys, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Set<@NonNull TypedTuple<V>> unionWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull Aggregate var3, @NonNull Weights var4);

    public Long unionAndStore(@NonNull K var1, @NonNull K var2, @NonNull K var3);

    public Long unionAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3);

    default public Long unionAndStore(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull K destKey, @NonNull Aggregate aggregate) {
        return this.unionAndStore(key, otherKeys, destKey, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Long unionAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3, @NonNull Aggregate var4, @NonNull Weights var5);

    public @NonNull Cursor<@NonNull TypedTuple<V>> scan(@NonNull K var1, @Nullable ScanOptions var2);

    default public Set<V> rangeByLex(@NonNull K key, @NonNull Range<String> range) {
        return this.rangeByLex(key, range, Limit.unlimited());
    }

    public Set<V> rangeByLex(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public Set<V> reverseRangeByLex(@NonNull K key, @NonNull Range<String> range) {
        return this.reverseRangeByLex(key, range, Limit.unlimited());
    }

    public Set<V> reverseRangeByLex(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    default public Long rangeAndStoreByLex(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<String> range) {
        return this.rangeAndStoreByLex(srcKey, dstKey, range, Limit.unlimited());
    }

    public Long rangeAndStoreByLex(@NonNull K var1, @NonNull K var2, @NonNull Range<String> var3, @NonNull Limit var4);

    default public Long reverseRangeAndStoreByLex(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<String> range) {
        return this.reverseRangeAndStoreByLex(srcKey, dstKey, range, Limit.unlimited());
    }

    public Long reverseRangeAndStoreByLex(@NonNull K var1, @NonNull K var2, @NonNull Range<String> var3, @NonNull Limit var4);

    default public Long rangeAndStoreByScore(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<? extends Number> range) {
        return this.rangeAndStoreByScore(srcKey, dstKey, range, Limit.unlimited());
    }

    public Long rangeAndStoreByScore(@NonNull K var1, @NonNull K var2, @NonNull Range<? extends Number> var3, @NonNull Limit var4);

    default public Long reverseRangeAndStoreByScore(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<? extends Number> range) {
        return this.reverseRangeAndStoreByScore(srcKey, dstKey, range, Limit.unlimited());
    }

    public Long reverseRangeAndStoreByScore(@NonNull K var1, @NonNull K var2, @NonNull Range<? extends Number> var3, @NonNull Limit var4);

    public @NonNull RedisOperations<K, V> getOperations();

    @NullMarked
    public static interface TypedTuple<V>
    extends Comparable<TypedTuple<V>> {
        public @Nullable V getValue();

        public @Nullable Double getScore();

        public static <V> TypedTuple<V> of(@NonNull V value, @Nullable Double score) {
            return new DefaultTypedTuple<V>(value, score);
        }
    }
}

