/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.dialect.InsertRenderContext;
import org.springframework.data.relational.core.dialect.InsertRenderContexts;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.OrderByNullPrecedence;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;

public interface Dialect {
    public LimitClause limit();

    public LockClause lock();

    default public ArrayColumns getArraySupport() {
        return ArrayColumns.Unsupported.INSTANCE;
    }

    public SelectRenderContext getSelectContext();

    default public IdentifierProcessing getIdentifierProcessing() {
        return IdentifierProcessing.ANSI;
    }

    default public Escaper getLikeEscaper() {
        return Escaper.DEFAULT;
    }

    default public IdGeneration getIdGeneration() {
        return IdGeneration.DEFAULT;
    }

    default public Collection<Object> getConverters() {
        return Collections.emptySet();
    }

    default public Set<Class<?>> simpleTypes() {
        return Collections.emptySet();
    }

    default public InsertRenderContext getInsertRenderContext() {
        return InsertRenderContexts.DEFAULT;
    }

    default public OrderByNullPrecedence orderByNullHandling() {
        return OrderByNullPrecedence.SQL_STANDARD;
    }
}

