/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import java.util.OptionalLong;
import java.util.function.Function;
import org.springframework.data.domain.Sort;
import org.springframework.data.relational.core.dialect.OrderByNullPrecedence;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.Select;

public interface SelectRenderContext {
    default public Function<Select, ? extends CharSequence> afterSelectList() {
        return select -> "";
    }

    default public Function<Select, ? extends CharSequence> afterFromTable() {
        return select -> "";
    }

    default public Function<Select, ? extends CharSequence> afterOrderBy(boolean hasOrderBy) {
        return select -> {
            String lockPrefix;
            OptionalLong limit = select.getLimit();
            OptionalLong offset = select.getOffset();
            LockMode lockMode = select.getLockMode();
            String string = lockPrefix = lockMode == null ? "" : " FOR UPDATE";
            if (limit.isPresent() && offset.isPresent()) {
                return String.format("%s OFFSET %d ROWS FETCH FIRST %d ROWS ONLY", lockPrefix, offset.getAsLong(), limit.getAsLong());
            }
            if (limit.isPresent()) {
                return String.format("%s FETCH FIRST %d ROWS ONLY", lockPrefix, limit.getAsLong());
            }
            if (offset.isPresent()) {
                return String.format("%s OFFSET %d ROWS", lockPrefix, offset.getAsLong());
            }
            return lockPrefix;
        };
    }

    default public String evaluateOrderByNullHandling(Sort.NullHandling nullHandling) {
        return OrderByNullPrecedence.NONE.evaluate(nullHandling);
    }
}

