/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RepositoryController;
import org.springframework.data.rest.webmvc.RepositoryEntityController;
import org.springframework.data.rest.webmvc.RepositoryPropertyReferenceController;
import org.springframework.data.rest.webmvc.RepositorySchemaController;
import org.springframework.data.rest.webmvc.RepositorySearchController;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.server.EntityLinks;

@Configuration(proxyBeanMethods=false)
public class RestControllerConfiguration {
    private final RepositoryRestConfiguration restConfiguration;
    private final RepositoryResourceMappings resourceMappings;
    private final PagedResourcesAssembler<Object> resourcesAssembler;
    private final Repositories repositories;

    RestControllerConfiguration(RepositoryRestConfiguration restConfiguration, RepositoryResourceMappings resourceMappings, PagedResourcesAssembler<Object> resourcesAssembler, Repositories repositories) {
        this.restConfiguration = restConfiguration;
        this.resourceMappings = resourceMappings;
        this.resourcesAssembler = resourcesAssembler;
        this.repositories = repositories;
    }

    @Bean
    RepositoryController repositoryController(EntityLinks entityLinks) {
        return new RepositoryController(this.resourcesAssembler, this.repositories, entityLinks, (ResourceMappings)this.resourceMappings);
    }

    @Bean
    RepositoryEntityController repositoryEntityController(RepositoryEntityLinks entityLinks, HttpHeadersPreparer headersPreparer) {
        return new RepositoryEntityController(this.repositories, this.restConfiguration, entityLinks, this.resourcesAssembler, headersPreparer);
    }

    @Bean
    RepositoryPropertyReferenceController repositoryPropertyReferenceController(RepositoryInvokerFactory repositoryInvokerFactory) {
        return new RepositoryPropertyReferenceController(this.repositories, repositoryInvokerFactory, this.resourcesAssembler);
    }

    @Bean
    RepositorySearchController repositorySearchController(RepositoryEntityLinks entityLinks, HttpHeadersPreparer headersPreparer) {
        return new RepositorySearchController(this.resourcesAssembler, entityLinks, (ResourceMappings)this.resourceMappings, headersPreparer);
    }

    @Bean
    RepositorySchemaController repositorySchemaController(PersistentEntityToJsonSchemaConverter jsonSchemaConverter) {
        return new RepositorySchemaController(jsonSchemaConverter);
    }

    @Bean
    AlpsController alpsController() {
        return new AlpsController(this.restConfiguration);
    }

    @Bean
    ProfileController profileController() {
        return new ProfileController(this.restConfiguration, this.resourceMappings, this.repositories);
    }
}

