/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.util.Optionals;
import org.springframework.util.Assert;

class WrappedProperties {
    private static final ClassIntrospector INTROSPECTOR = new BasicClassIntrospector();
    private static final AnnotationIntrospector ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    private final Map<String, List<PersistentProperty<?>>> fieldNameToProperties;

    private WrappedProperties(Map<String, List<PersistentProperty<?>>> fieldNameToProperties) {
        this.fieldNameToProperties = new HashMap(fieldNameToProperties);
    }

    public static WrappedProperties fromJacksonProperties(PersistentEntities persistentEntities, PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        Assert.notNull(entity, (String)"PersistentEntity must not be null");
        JacksonUnwrappedPropertiesResolver resolver = new JacksonUnwrappedPropertiesResolver(persistentEntities, mapper);
        return new WrappedProperties(resolver.findUnwrappedPropertyPaths(entity.getType()));
    }

    public static WrappedProperties none() {
        return new WrappedProperties(Collections.emptyMap());
    }

    public boolean hasPersistentPropertiesForField(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty");
        return this.fieldNameToProperties.containsKey(fieldName);
    }

    public List<PersistentProperty<?>> getPersistentProperties(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty");
        return this.hasPersistentPropertiesForField(fieldName) ? Collections.unmodifiableList(this.fieldNameToProperties.get(fieldName)) : Collections.emptyList();
    }

    static class JacksonUnwrappedPropertiesResolver {
        private final PersistentEntities entities;
        private final ObjectMapper mapper;

        public JacksonUnwrappedPropertiesResolver(PersistentEntities entities, ObjectMapper mapper) {
            Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
            Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
            this.entities = entities;
            this.mapper = mapper;
        }

        public Map<String, List<PersistentProperty<?>>> findUnwrappedPropertyPaths(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null");
            return this.findUnwrappedPropertyPaths(type, NameTransformer.NOP, false);
        }

        private Map<String, List<PersistentProperty<?>>> findUnwrappedPropertyPaths(Class<?> type, NameTransformer nameTransformer, boolean considerRegularProperties) {
            return this.entities.getPersistentEntity(type).map(entity -> {
                HashMap mapping = new HashMap();
                for (BeanPropertyDefinition property : this.getMappedProperties((PersistentEntity<?, ?>)entity)) {
                    Optionals.ifAllPresent(Optional.ofNullable(entity.getPersistentProperty(property.getInternalName())), JacksonUnwrappedPropertiesResolver.findAnnotatedMember(property), (prop, member) -> {
                        if (JacksonUnwrappedPropertiesResolver.isJsonUnwrapped(member)) {
                            mapping.putAll(this.findUnwrappedPropertyPaths(nameTransformer, (AnnotatedMember)member, (PersistentProperty<?>)prop));
                        } else if (considerRegularProperties) {
                            mapping.put(nameTransformer.transform(property.getName()), Collections.singletonList(prop));
                        }
                    });
                }
                return mapping;
            }).orElse(Collections.emptyMap());
        }

        private Map<String, List<PersistentProperty<?>>> findUnwrappedPropertyPaths(NameTransformer nameTransformer, AnnotatedMember annotatedMember, PersistentProperty<?> persistentProperty) {
            HashMap mapping = new HashMap();
            NameTransformer propertyNameTransformer = NameTransformer.chainedTransformer((NameTransformer)nameTransformer, (NameTransformer)ANNOTATION_INTROSPECTOR.findUnwrappingNameTransformer(annotatedMember));
            Map<String, List<PersistentProperty<?>>> nestedProperties = this.findUnwrappedPropertyPaths(annotatedMember.getRawType(), propertyNameTransformer, true);
            for (Map.Entry<String, List<PersistentProperty<?>>> entry : nestedProperties.entrySet()) {
                ArrayList persistentProperties = new ArrayList();
                persistentProperties.add(persistentProperty);
                persistentProperties.addAll((Collection)entry.getValue());
                mapping.put(entry.getKey(), persistentProperties);
            }
            return mapping;
        }

        private List<BeanPropertyDefinition> getMappedProperties(PersistentEntity<?, ?> entity) {
            List properties = this.getBeanDescription(entity.getType()).findProperties();
            ArrayList<BeanPropertyDefinition> withInternalName = new ArrayList<BeanPropertyDefinition>(properties.size());
            for (BeanPropertyDefinition property : properties) {
                Optionals.ifAllPresent(JacksonUnwrappedPropertiesResolver.findAnnotatedMember(property), Optional.ofNullable(entity.getPersistentProperty(property.getInternalName())), (member, prop) -> withInternalName.add(property));
            }
            return withInternalName;
        }

        private BeanDescription getBeanDescription(Class<?> type) {
            SerializationConfig config = this.mapper.getSerializationConfig();
            return INTROSPECTOR.forSerialization(config, this.mapper.constructType(type), (ClassIntrospector.MixInResolver)config);
        }

        private static Optional<AnnotatedMember> findAnnotatedMember(BeanPropertyDefinition property) {
            if (property.getPrimaryMember() != null) {
                return Optional.of(property.getPrimaryMember());
            }
            if (property.getGetter() != null) {
                return Optional.of(property.getGetter());
            }
            if (property.getSetter() != null) {
                return Optional.of(property.getSetter());
            }
            return Optional.empty();
        }

        private static boolean isJsonUnwrapped(AnnotatedMember primaryMember) {
            return primaryMember.hasAnnotation(JsonUnwrapped.class) && ((JsonUnwrapped)primaryMember.getAnnotation(JsonUnwrapped.class)).enabled();
        }
    }
}

