/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public final class JUnitUtils {
    private static final Log LOGGER = LogFactory.getLog(JUnitUtils.class);

    private JUnitUtils() {
    }

    public static boolean parseBooleanProperty(String property) {
        for (String value : new String[]{System.getenv(property), System.getProperty(property)}) {
            if (!Boolean.parseBoolean(value)) continue;
            return true;
        }
        return false;
    }

    public static LevelsContainer adjustLogLevels(String methodName, List<Class<?>> classes, List<String> categories, Level level) {
        LoggerConfig specificConfig;
        LoggerConfig loggerConfig;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        HashMap classLevels = new HashMap();
        for (Class<?> cls : classes) {
            String className = cls.getName();
            specificConfig = loggerConfig = config.getLoggerConfig(className);
            if (!loggerConfig.getName().equals(className)) {
                specificConfig = new LoggerConfig(className, loggerConfig.getLevel(), true);
                specificConfig.setParent(loggerConfig);
                config.addLogger(className, specificConfig);
            }
            classLevels.put(cls, specificConfig.getLevel());
            specificConfig.setLevel(level);
        }
        HashMap<String, Level> categoryLevels = new HashMap<String, Level>();
        for (String category : categories) {
            specificConfig = loggerConfig = config.getLoggerConfig(category);
            if (!loggerConfig.getName().equals(category)) {
                specificConfig = new LoggerConfig(category, loggerConfig.getLevel(), true);
                specificConfig.setParent(loggerConfig);
                config.addLogger(category, specificConfig);
            }
            categoryLevels.put(category, specificConfig.getLevel());
            specificConfig.setLevel(level);
        }
        ctx.updateLoggers();
        LOGGER.info((Object)("++++++++++++++++++++++++++++ Overridden log level setting for: " + classes.stream().map(Class::getSimpleName).collect(Collectors.toList()) + " and " + categories.toString() + " for test " + methodName));
        return new LevelsContainer(classLevels, categoryLevels);
    }

    public static void revertLevels(String methodName, LevelsContainer container) {
        LOGGER.info((Object)("++++++++++++++++++++++++++++ Restoring log level setting for test " + methodName));
        container.oldCatLevels.forEach((key, value) -> ((Logger)LogManager.getLogger((String)key)).setLevel(value));
        container.oldLevels.forEach((key, value) -> ((Logger)LogManager.getLogger((Class)key)).setLevel(value));
    }

    public static class LevelsContainer {
        private final Map<Class<?>, Level> oldLevels;
        private final Map<String, Level> oldCatLevels;

        public LevelsContainer(Map<Class<?>, Level> oldLevels, Map<String, Level> oldCatLevels) {
            this.oldLevels = oldLevels;
            this.oldCatLevels = oldCatLevels;
        }
    }
}

