/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.core.ResolvableType;
import org.springframework.security.oauth2.client.AuthorizationCodeOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ClientCredentialsOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.DelegatingOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.JwtBearerOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.PasswordOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.TokenExchangeOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.JwtBearerGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.endpoint.TokenExchangeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;

final class OAuth2AuthorizedClientManagerRegistrar
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware {
    static final String BEAN_NAME = "authorizedClientManagerRegistrar";
    static final String FACTORY_METHOD_NAME = "getAuthorizedClientManager";
    private static final Set<Class<?>> KNOWN_AUTHORIZED_CLIENT_PROVIDERS = Set.of(AuthorizationCodeOAuth2AuthorizedClientProvider.class, RefreshTokenOAuth2AuthorizedClientProvider.class, ClientCredentialsOAuth2AuthorizedClientProvider.class, PasswordOAuth2AuthorizedClientProvider.class, JwtBearerOAuth2AuthorizedClientProvider.class, TokenExchangeOAuth2AuthorizedClientProvider.class);
    private final AnnotationBeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
    private ListableBeanFactory beanFactory;

    OAuth2AuthorizedClientManagerRegistrar() {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.getBeanNamesForType(OAuth2AuthorizedClientManager.class).length != 0 || this.getBeanNamesForType(ClientRegistrationRepository.class).length != 1 || this.getBeanNamesForType(OAuth2AuthorizedClientRepository.class).length != 1) {
            return;
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizedClientManager.class).setFactoryMethodOnBean(FACTORY_METHOD_NAME, BEAN_NAME).getBeanDefinition();
        registry.registerBeanDefinition(this.beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, registry), (BeanDefinition)beanDefinition);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    private OAuth2AuthorizedClientManager getAuthorizedClientManager() {
        OAuth2AuthorizedClientProvider authorizedClientProvider;
        ClientRegistrationRepository clientRegistrationRepository = (ClientRegistrationRepository)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ClientRegistrationRepository.class, (boolean)true, (boolean)true);
        OAuth2AuthorizedClientRepository authorizedClientRepository = (OAuth2AuthorizedClientRepository)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, OAuth2AuthorizedClientRepository.class, (boolean)true, (boolean)true);
        Collection<OAuth2AuthorizedClientProvider> authorizedClientProviderBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, OAuth2AuthorizedClientProvider.class, (boolean)true, (boolean)true).values();
        if (this.hasDelegatingAuthorizedClientProvider(authorizedClientProviderBeans)) {
            authorizedClientProvider = authorizedClientProviderBeans.iterator().next();
        } else {
            OAuth2AuthorizedClientProvider tokenExchangeAuthorizedClientProvider;
            ArrayList<OAuth2AuthorizedClientProvider> authorizedClientProviders = new ArrayList<OAuth2AuthorizedClientProvider>();
            authorizedClientProviders.add(this.getAuthorizationCodeAuthorizedClientProvider(authorizedClientProviderBeans));
            authorizedClientProviders.add(this.getRefreshTokenAuthorizedClientProvider(authorizedClientProviderBeans));
            authorizedClientProviders.add(this.getClientCredentialsAuthorizedClientProvider(authorizedClientProviderBeans));
            authorizedClientProviders.add(this.getPasswordAuthorizedClientProvider(authorizedClientProviderBeans));
            OAuth2AuthorizedClientProvider jwtBearerAuthorizedClientProvider = this.getJwtBearerAuthorizedClientProvider(authorizedClientProviderBeans);
            if (jwtBearerAuthorizedClientProvider != null) {
                authorizedClientProviders.add(jwtBearerAuthorizedClientProvider);
            }
            if ((tokenExchangeAuthorizedClientProvider = this.getTokenExchangeAuthorizedClientProvider(authorizedClientProviderBeans)) != null) {
                authorizedClientProviders.add(tokenExchangeAuthorizedClientProvider);
            }
            authorizedClientProviders.addAll(this.getAdditionalAuthorizedClientProviders(authorizedClientProviderBeans));
            authorizedClientProvider = new DelegatingOAuth2AuthorizedClientProvider(authorizedClientProviders);
        }
        DefaultOAuth2AuthorizedClientManager authorizedClientManager = new DefaultOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        Consumer authorizedClientManagerConsumer = (Consumer)this.getBeanOfType(ResolvableType.forClassWithGenerics(Consumer.class, (Class[])new Class[]{DefaultOAuth2AuthorizedClientManager.class}));
        if (authorizedClientManagerConsumer != null) {
            authorizedClientManagerConsumer.accept(authorizedClientManager);
        }
        return authorizedClientManager;
    }

    private boolean hasDelegatingAuthorizedClientProvider(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        if (authorizedClientProviders.size() != 1) {
            return false;
        }
        return authorizedClientProviders.iterator().next() instanceof DelegatingOAuth2AuthorizedClientProvider;
    }

    private OAuth2AuthorizedClientProvider getAuthorizationCodeAuthorizedClientProvider(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        AuthorizationCodeOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, AuthorizationCodeOAuth2AuthorizedClientProvider.class);
        if (authorizedClientProvider == null) {
            authorizedClientProvider = new AuthorizationCodeOAuth2AuthorizedClientProvider();
        }
        return authorizedClientProvider;
    }

    private OAuth2AuthorizedClientProvider getRefreshTokenAuthorizedClientProvider(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        OAuth2AccessTokenResponseClient accessTokenResponseClient;
        RefreshTokenOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, RefreshTokenOAuth2AuthorizedClientProvider.class);
        if (authorizedClientProvider == null) {
            authorizedClientProvider = new RefreshTokenOAuth2AuthorizedClientProvider();
        }
        if ((accessTokenResponseClient = (OAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(OAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2RefreshTokenGrantRequest.class}))) != null) {
            authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
        }
        return authorizedClientProvider;
    }

    private OAuth2AuthorizedClientProvider getClientCredentialsAuthorizedClientProvider(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        OAuth2AccessTokenResponseClient accessTokenResponseClient;
        ClientCredentialsOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, ClientCredentialsOAuth2AuthorizedClientProvider.class);
        if (authorizedClientProvider == null) {
            authorizedClientProvider = new ClientCredentialsOAuth2AuthorizedClientProvider();
        }
        if ((accessTokenResponseClient = (OAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(OAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2ClientCredentialsGrantRequest.class}))) != null) {
            authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
        }
        return authorizedClientProvider;
    }

    private OAuth2AuthorizedClientProvider getPasswordAuthorizedClientProvider(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        OAuth2AccessTokenResponseClient accessTokenResponseClient;
        PasswordOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, PasswordOAuth2AuthorizedClientProvider.class);
        if (authorizedClientProvider == null) {
            authorizedClientProvider = new PasswordOAuth2AuthorizedClientProvider();
        }
        if ((accessTokenResponseClient = (OAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(OAuth2AccessTokenResponseClient.class, (Class[])new Class[]{OAuth2PasswordGrantRequest.class}))) != null) {
            authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
        }
        return authorizedClientProvider;
    }

    private OAuth2AuthorizedClientProvider getJwtBearerAuthorizedClientProvider(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        JwtBearerOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, JwtBearerOAuth2AuthorizedClientProvider.class);
        OAuth2AccessTokenResponseClient accessTokenResponseClient = (OAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(OAuth2AccessTokenResponseClient.class, (Class[])new Class[]{JwtBearerGrantRequest.class}));
        if (accessTokenResponseClient != null) {
            if (authorizedClientProvider == null) {
                authorizedClientProvider = new JwtBearerOAuth2AuthorizedClientProvider();
            }
            authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
        }
        return authorizedClientProvider;
    }

    private OAuth2AuthorizedClientProvider getTokenExchangeAuthorizedClientProvider(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        TokenExchangeOAuth2AuthorizedClientProvider authorizedClientProvider = this.getAuthorizedClientProviderByType(authorizedClientProviders, TokenExchangeOAuth2AuthorizedClientProvider.class);
        OAuth2AccessTokenResponseClient accessTokenResponseClient = (OAuth2AccessTokenResponseClient)this.getBeanOfType(ResolvableType.forClassWithGenerics(OAuth2AccessTokenResponseClient.class, (Class[])new Class[]{TokenExchangeGrantRequest.class}));
        if (accessTokenResponseClient != null) {
            if (authorizedClientProvider == null) {
                authorizedClientProvider = new TokenExchangeOAuth2AuthorizedClientProvider();
            }
            authorizedClientProvider.setAccessTokenResponseClient(accessTokenResponseClient);
        }
        return authorizedClientProvider;
    }

    private List<OAuth2AuthorizedClientProvider> getAdditionalAuthorizedClientProviders(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders) {
        ArrayList<OAuth2AuthorizedClientProvider> additionalAuthorizedClientProviders = new ArrayList<OAuth2AuthorizedClientProvider>(authorizedClientProviders);
        additionalAuthorizedClientProviders.removeIf(provider -> KNOWN_AUTHORIZED_CLIENT_PROVIDERS.contains(provider.getClass()));
        return additionalAuthorizedClientProviders;
    }

    private <T extends OAuth2AuthorizedClientProvider> T getAuthorizedClientProviderByType(Collection<OAuth2AuthorizedClientProvider> authorizedClientProviders, Class<T> providerClass) {
        OAuth2AuthorizedClientProvider authorizedClientProvider = null;
        for (OAuth2AuthorizedClientProvider current : authorizedClientProviders) {
            if (!providerClass.isInstance(current)) continue;
            OAuth2AuthorizedClientManagerRegistrar.assertAuthorizedClientProviderIsNull(authorizedClientProvider);
            authorizedClientProvider = (OAuth2AuthorizedClientProvider)providerClass.cast(current);
        }
        return (T)authorizedClientProvider;
    }

    private static void assertAuthorizedClientProviderIsNull(OAuth2AuthorizedClientProvider authorizedClientProvider) {
        if (authorizedClientProvider != null) {
            throw new BeanInitializationException(String.format("Unable to create an %s bean. Expected one bean of type %s, but found multiple. Please consider defining only a single bean of this type, or define an %s bean yourself.", OAuth2AuthorizedClientManager.class.getName(), authorizedClientProvider.getClass().getName(), OAuth2AuthorizedClientManager.class.getName()));
        }
    }

    private <T> String[] getBeanNamesForType(Class<T> beanClass) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, beanClass, (boolean)false, (boolean)false);
    }

    private <T> T getBeanOfType(ResolvableType resolvableType) {
        ObjectProvider objectProvider = this.beanFactory.getBeanProvider(resolvableType, true);
        return (T)objectProvider.getIfAvailable();
    }
}

