/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data.jpa;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.springframework.statemachine.data.RepositoryTransition;
import org.springframework.statemachine.data.jpa.JpaRepositoryAction;
import org.springframework.statemachine.data.jpa.JpaRepositoryGuard;
import org.springframework.statemachine.data.jpa.JpaRepositoryState;
import org.springframework.statemachine.transition.TransitionKind;

@Entity
@Table(name="Transition")
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
public class JpaRepositoryTransition
extends RepositoryTransition {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    private String machineId;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_transition_source"))
    private JpaRepositoryState source;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_transition_target"))
    private JpaRepositoryState target;
    private String event;
    private TransitionKind kind;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(foreignKey=@ForeignKey(name="fk_transition_actions_t"), inverseForeignKey=@ForeignKey(name="fk_transition_actions_a"))
    private Set<JpaRepositoryAction> actions;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(foreignKey=@ForeignKey(name="fk_transition_guard"))
    private JpaRepositoryGuard guard;

    public JpaRepositoryTransition() {
        this(null, null, null);
    }

    public JpaRepositoryTransition(JpaRepositoryState source, JpaRepositoryState target, String event) {
        this(null, source, target, event);
    }

    public JpaRepositoryTransition(String machineId, JpaRepositoryState source, JpaRepositoryState target, String event) {
        this(machineId, source, target, event, null);
    }

    public JpaRepositoryTransition(String machineId, JpaRepositoryState source, JpaRepositoryState target, String event, Set<JpaRepositoryAction> actions) {
        this.machineId = machineId == null ? "" : machineId;
        this.source = source;
        this.target = target;
        this.event = event;
        this.actions = actions;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public JpaRepositoryState getSource() {
        return this.source;
    }

    public void setSource(JpaRepositoryState source) {
        this.source = source;
    }

    public JpaRepositoryState getTarget() {
        return this.target;
    }

    public void setTarget(JpaRepositoryState target) {
        this.target = target;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public Set<JpaRepositoryAction> getActions() {
        return this.actions;
    }

    public void setActions(Set<JpaRepositoryAction> actions) {
        this.actions = actions;
    }

    public JpaRepositoryGuard getGuard() {
        return this.guard;
    }

    public void setGuard(JpaRepositoryGuard guard) {
        this.guard = guard;
    }

    public TransitionKind getKind() {
        return this.kind;
    }

    public void setKind(TransitionKind kind) {
        this.kind = kind;
    }

    public String toString() {
        return "JpaRepositoryTransition [id=" + this.id + ", machineId=" + this.machineId + ", source=" + (Object)((Object)this.source) + ", target=" + (Object)((Object)this.target) + ", event=" + this.event + ", kind=" + this.kind + ", actions=" + this.actions + ", guard=" + (Object)((Object)this.guard) + "]";
    }
}

