/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;
import org.ssssssss.magicapi.core.context.MagicUser;

public class MagicConsoleSession {
    private static final Map<String, MagicConsoleSession> cached = new ConcurrentHashMap<String, MagicConsoleSession>();
    private String clientId;
    private WebSocketSession webSocketSession;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private long activateTime = System.currentTimeMillis();
    private MagicUser user;
    private long timeout;

    public MagicConsoleSession(WebSocketSession webSocketSession) {
        this.webSocketSession = webSocketSession;
    }

    public String getClientId() {
        return this.clientId;
    }

    public WebSocketSession getWebSocketSession() {
        return this.webSocketSession;
    }

    public boolean writeable() {
        return this.webSocketSession != null && this.webSocketSession.isOpen();
    }

    public static MagicConsoleSession from(WebSocketSession session) {
        MagicConsoleSession magicConsoleSession = cached.get(session.getId());
        if (magicConsoleSession == null) {
            magicConsoleSession = new MagicConsoleSession(session);
            cached.put(session.getId(), magicConsoleSession);
        }
        return magicConsoleSession;
    }

    public static void remove(WebSocketSession session) {
        cached.remove(session.getId());
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
        this.setAttribute("cid", clientId);
    }

    public long getActivateTime() {
        return this.activateTime;
    }

    public void setActivateTime(long activateTime) {
        this.activateTime = activateTime;
    }

    public void close() {
        if (this.webSocketSession != null) {
            MagicConsoleSession.remove(this.webSocketSession);
            try {
                this.webSocketSession.close(CloseStatus.SESSION_NOT_RELIABLE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.webSocketSession = null;
        }
    }

    public MagicUser getUser() {
        return this.user;
    }

    public void setUser(MagicUser user) {
        this.user = user;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

