/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Squeeze<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> Squeeze<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("Squeeze", scope.makeOpName("Squeeze"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.axis == null) continue;
                long[] axisArray = new long[opts.axis.size()];
                for (int i = 0; i < axisArray.length; ++i) {
                    axisArray[i] = (Long)opts.axis.get(i);
                }
                opBuilder.setAttr("squeeze_dims", axisArray);
            }
        }
        return new Squeeze<T>(opBuilder.build());
    }

    public static Options axis(List<Long> axis) {
        return new Options().axis(axis);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Squeeze(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private List<Long> axis;

        public Options axis(List<Long> axis) {
            this.axis = axis;
            return this;
        }

        private Options() {
        }
    }
}

