/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorListConcat<T>
extends PrimitiveOp {
    private Output<T> tensor;
    private Output<Long> lengths;

    public static <T> TensorListConcat<T> create(Scope scope, Operand<?> inputHandle, Class<T> elementDtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("TensorListConcat", scope.makeOpName("TensorListConcat"));
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("element_dtype", DataType.fromClass(elementDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShape == null) continue;
                opBuilder.setAttr("element_shape", opts.elementShape);
            }
        }
        return new TensorListConcat<T>(opBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    public Output<Long> lengths() {
        return this.lengths;
    }

    private TensorListConcat(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
        this.lengths = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape elementShape;

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }

        private Options() {
        }
    }
}

