/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.UInt8;

public final class EncodeJpeg
extends PrimitiveOp
implements Operand<String> {
    private Output<String> contents;

    public static EncodeJpeg create(Scope scope, Operand<UInt8> image, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("EncodeJpeg", scope.makeOpName("EncodeJpeg"));
        opBuilder.addInput(image.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.format != null) {
                    opBuilder.setAttr("format", opts.format);
                }
                if (opts.quality != null) {
                    opBuilder.setAttr("quality", opts.quality);
                }
                if (opts.progressive != null) {
                    opBuilder.setAttr("progressive", opts.progressive);
                }
                if (opts.optimizeSize != null) {
                    opBuilder.setAttr("optimize_size", opts.optimizeSize);
                }
                if (opts.chromaDownsampling != null) {
                    opBuilder.setAttr("chroma_downsampling", opts.chromaDownsampling);
                }
                if (opts.densityUnit != null) {
                    opBuilder.setAttr("density_unit", opts.densityUnit);
                }
                if (opts.xDensity != null) {
                    opBuilder.setAttr("x_density", opts.xDensity);
                }
                if (opts.yDensity != null) {
                    opBuilder.setAttr("y_density", opts.yDensity);
                }
                if (opts.xmpMetadata == null) continue;
                opBuilder.setAttr("xmp_metadata", opts.xmpMetadata);
            }
        }
        return new EncodeJpeg(opBuilder.build());
    }

    public static Options format(String format) {
        return new Options().format(format);
    }

    public static Options quality(Long quality) {
        return new Options().quality(quality);
    }

    public static Options progressive(Boolean progressive) {
        return new Options().progressive(progressive);
    }

    public static Options optimizeSize(Boolean optimizeSize) {
        return new Options().optimizeSize(optimizeSize);
    }

    public static Options chromaDownsampling(Boolean chromaDownsampling) {
        return new Options().chromaDownsampling(chromaDownsampling);
    }

    public static Options densityUnit(String densityUnit) {
        return new Options().densityUnit(densityUnit);
    }

    public static Options xDensity(Long xDensity) {
        return new Options().xDensity(xDensity);
    }

    public static Options yDensity(Long yDensity) {
        return new Options().yDensity(yDensity);
    }

    public static Options xmpMetadata(String xmpMetadata) {
        return new Options().xmpMetadata(xmpMetadata);
    }

    public Output<String> contents() {
        return this.contents;
    }

    @Override
    public Output<String> asOutput() {
        return this.contents;
    }

    private EncodeJpeg(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.contents = operation.output(outputIdx++);
    }

    public static class Options {
        private String format;
        private Long quality;
        private Boolean progressive;
        private Boolean optimizeSize;
        private Boolean chromaDownsampling;
        private String densityUnit;
        private Long xDensity;
        private Long yDensity;
        private String xmpMetadata;

        public Options format(String format) {
            this.format = format;
            return this;
        }

        public Options quality(Long quality) {
            this.quality = quality;
            return this;
        }

        public Options progressive(Boolean progressive) {
            this.progressive = progressive;
            return this;
        }

        public Options optimizeSize(Boolean optimizeSize) {
            this.optimizeSize = optimizeSize;
            return this;
        }

        public Options chromaDownsampling(Boolean chromaDownsampling) {
            this.chromaDownsampling = chromaDownsampling;
            return this;
        }

        public Options densityUnit(String densityUnit) {
            this.densityUnit = densityUnit;
            return this;
        }

        public Options xDensity(Long xDensity) {
            this.xDensity = xDensity;
            return this;
        }

        public Options yDensity(Long yDensity) {
            this.yDensity = yDensity;
            return this;
        }

        public Options xmpMetadata(String xmpMetadata) {
            this.xmpMetadata = xmpMetadata;
            return this;
        }

        private Options() {
        }
    }
}

